/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import com.portingdeadmods.nautec.compat.modonomicon.ModonomiconCompat;
import com.portingdeadmods.nautec.content.items.AirBottleItem;
import com.portingdeadmods.nautec.content.items.AquarineArmorItem;
import com.portingdeadmods.nautec.content.items.BatteryItem;
import com.portingdeadmods.nautec.content.items.DivingSuitArmorItem;
import com.portingdeadmods.nautec.content.items.GraftingToolItem;
import com.portingdeadmods.nautec.content.items.NeptunesTridentItem;
import com.portingdeadmods.nautec.content.items.PetriDishItem;
import com.portingdeadmods.nautec.content.items.PrismMonocleItem;
import com.portingdeadmods.nautec.content.items.RobotArmItem;
import com.portingdeadmods.nautec.content.items.tiers.NTArmorMaterials;
import com.portingdeadmods.nautec.content.items.tools.AquarineAxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineHoeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarinePickaxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineShovelItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineSwordItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineWrenchItem;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentBacteriaStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NTItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"nautec");
    public static final List<ItemLike> CREATIVE_TAB_ITEMS = new ArrayList<ItemLike>();
    public static final List<ItemLike> BACTERIA_ITEMS = new ArrayList<ItemLike>();
    public static final List<Supplier<BlockItem>> BLOCK_ITEMS = new ArrayList<Supplier<BlockItem>>();
    public static final Supplier<Item> NAUTEC_GUIDE;
    public static final DeferredItem<Item> AQUARINE_STEEL_INGOT;
    public static final DeferredItem<Item> ATLANTIC_GOLD_INGOT;
    public static final DeferredItem<Item> ATLANTIC_GOLD_NUGGET;
    public static final DeferredItem<Item> PRISMARINE_CRYSTAL_SHARD;
    public static final DeferredItem<Item> PRISMARINE_LENS;
    public static final DeferredItem<AirBottleItem> AIR_BOTTLE;
    public static final DeferredItem<Item> AQUARINE_STEEL_COMPOUND;
    public static final DeferredItem<Item> CAST_IRON_COMPOUND;
    public static final DeferredItem<Item> SALT;
    public static final DeferredItem<Item> RUSTY_GEAR;
    public static final DeferredItem<Item> GEAR;
    public static final DeferredItem<Item> ANCIENT_VALVE;
    public static final DeferredItem<Item> VALVE;
    public static final DeferredItem<Item> BROKEN_WHISK;
    public static final DeferredItem<Item> WHISK;
    public static final DeferredItem<Item> DAMAGED_AQUATIC_CHIP;
    public static final DeferredItem<Item> AQUATIC_CHIP;
    public static final DeferredItem<Item> BURNT_COIL;
    public static final DeferredItem<Item> LASER_CHANNELING_COIL;
    public static final DeferredItem<Item> CAST_IRON_INGOT;
    public static final DeferredItem<Item> CAST_IRON_NUGGET;
    public static final DeferredItem<Item> CAST_IRON_ROD;
    public static final DeferredItem<Item> BROWN_POLYMER;
    public static final DeferredItem<Item> DROWNED_LUNGS;
    public static final DeferredItem<Item> DOLPHIN_FIN;
    public static final DeferredItem<Item> GUARDIAN_EYE;
    public static final DeferredItem<Item> ELDRITCH_HEART;
    public static final DeferredItem<RobotArmItem> CLAW_ROBOT_ARM;
    public static final DeferredItem<Item> GLASS_VIAL;
    public static final DeferredItem<Item> ELECTROLYTE_ALGAE_SERUM_VIAL;
    public static final DeferredItem<GraftingToolItem> GRAFTING_TOOL;
    public static final DeferredItem<PetriDishItem> PETRI_DISH;
    public static final DeferredItem<BatteryItem> PRISMATIC_BATTERY;
    public static final DeferredItem<PrismMonocleItem> PRISM_MONOCLE;
    public static final DeferredItem<DivingSuitArmorItem> DIVING_HELMET;
    public static final DeferredItem<DivingSuitArmorItem> DIVING_CHESTPLATE;
    public static final DeferredItem<DivingSuitArmorItem> DIVING_LEGGINGS;
    public static final DeferredItem<DivingSuitArmorItem> DIVING_BOOTS;
    public static final DeferredItem<AquarineArmorItem> AQUARINE_HELMET;
    public static final DeferredItem<AquarineArmorItem> AQUARINE_CHESTPLATE;
    public static final DeferredItem<AquarineArmorItem> AQUARINE_LEGGINGS;
    public static final DeferredItem<AquarineArmorItem> AQUARINE_BOOTS;
    public static final DeferredItem<NeptunesTridentItem> NEPTUNES_TRIDENT;
    public static final DeferredItem<AquarineSwordItem> AQUARINE_SWORD;
    public static final DeferredItem<AquarineAxeItem> AQUARINE_AXE;
    public static final DeferredItem<AquarineHoeItem> AQUARINE_HOE;
    public static final DeferredItem<AquarinePickaxeItem> AQUARINE_PICKAXE;
    public static final DeferredItem<AquarineShovelItem> AQUARINE_SHOVEL;
    public static final DeferredItem<AquarineWrenchItem> AQUARINE_WRENCH;
    public static final DeferredItem<Item> CROWBAR;

    public static <T extends Item> DeferredItem<T> bacteriaItem(DeferredItem<T> item) {
        BACTERIA_ITEMS.add((ItemLike)item);
        return item;
    }

    public static <T extends Item> DeferredItem<T> registerItem(String name, Function<Item.Properties, T> itemConstructor, Item.Properties properties) {
        return NTItems.registerItem(name, itemConstructor, properties, true);
    }

    public static <T extends Item> DeferredItem<T> registerItem(String name, Function<Item.Properties, T> itemConstructor, Supplier<Item.Properties> properties) {
        return NTItems.registerItem(name, itemConstructor, properties, true);
    }

    private static <T extends Item> DeferredItem<T> registerItemBucket(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Item> DeferredItem<T> registerItem(String name, Supplier<T> item) {
        DeferredItem toReturn = ITEMS.register(name, item);
        CREATIVE_TAB_ITEMS.add((ItemLike)toReturn);
        return toReturn;
    }

    public static <T extends Item> DeferredItem<T> registerItem(String name, Function<Item.Properties, T> itemConstructor, Item.Properties properties, boolean addToTab) {
        DeferredItem toReturn = ITEMS.registerItem(name, itemConstructor, properties);
        if (addToTab) {
            CREATIVE_TAB_ITEMS.add((ItemLike)toReturn);
        }
        return toReturn;
    }

    public static <T extends Item> DeferredItem<T> registerItem(String name, Function<Item.Properties, T> itemConstructor, Supplier<Item.Properties> properties, boolean addToTab) {
        DeferredItem toReturn = ITEMS.register(name, () -> (Item)itemConstructor.apply((Item.Properties)properties.get()));
        if (addToTab) {
            CREATIVE_TAB_ITEMS.add((ItemLike)toReturn);
        }
        return toReturn;
    }

    static {
        AQUARINE_STEEL_INGOT = NTItems.registerItem("aquarine_steel_ingot", Item::new, new Item.Properties());
        ATLANTIC_GOLD_INGOT = NTItems.registerItem("atlantic_gold_ingot", Item::new, new Item.Properties());
        ATLANTIC_GOLD_NUGGET = NTItems.registerItem("atlantic_gold_nugget", Item::new, new Item.Properties());
        PRISMARINE_CRYSTAL_SHARD = NTItems.registerItem("prismarine_crystal_shard", Item::new, new Item.Properties());
        PRISMARINE_LENS = NTItems.registerItem("prismarine_lens", Item::new, new Item.Properties().stacksTo(1));
        AIR_BOTTLE = NTItems.registerItem("air_bottle", AirBottleItem::new, new Item.Properties().stacksTo(16));
        AQUARINE_STEEL_COMPOUND = NTItems.registerItem("aquarine_steel_compound", Item::new, new Item.Properties());
        CAST_IRON_COMPOUND = NTItems.registerItem("cast_iron_compound", Item::new, new Item.Properties());
        SALT = NTItems.registerItem("salt", Item::new, new Item.Properties());
        RUSTY_GEAR = NTItems.registerItem("rusty_gear", Item::new, new Item.Properties());
        GEAR = NTItems.registerItem("gear", Item::new, new Item.Properties());
        ANCIENT_VALVE = NTItems.registerItem("ancient_valve", Item::new, new Item.Properties());
        VALVE = NTItems.registerItem("valve", Item::new, new Item.Properties());
        BROKEN_WHISK = NTItems.registerItem("broken_whisk", Item::new, new Item.Properties());
        WHISK = NTItems.registerItem("whisk", Item::new, new Item.Properties());
        DAMAGED_AQUATIC_CHIP = NTItems.registerItem("damaged_aquatic_chip", Item::new, new Item.Properties());
        AQUATIC_CHIP = NTItems.registerItem("aquatic_chip", Item::new, new Item.Properties());
        BURNT_COIL = NTItems.registerItem("burnt_coil", Item::new, new Item.Properties());
        LASER_CHANNELING_COIL = NTItems.registerItem("laser_channeling_coil", Item::new, new Item.Properties());
        CAST_IRON_INGOT = NTItems.registerItem("cast_iron_ingot", Item::new, new Item.Properties());
        CAST_IRON_NUGGET = NTItems.registerItem("cast_iron_nugget", Item::new, new Item.Properties());
        CAST_IRON_ROD = NTItems.registerItem("cast_iron_rod", Item::new, new Item.Properties());
        BROWN_POLYMER = NTItems.registerItem("brown_polymer", Item::new, new Item.Properties());
        DROWNED_LUNGS = NTItems.registerItem("drowned_lungs", Item::new, new Item.Properties());
        DOLPHIN_FIN = NTItems.registerItem("dolphin_fin", Item::new, new Item.Properties());
        GUARDIAN_EYE = NTItems.registerItem("guardian_eye", Item::new, new Item.Properties());
        ELDRITCH_HEART = NTItems.registerItem("eldritch_heart", Item::new, new Item.Properties());
        CLAW_ROBOT_ARM = NTItems.registerItem("claw_robot_arm", RobotArmItem::new, new Item.Properties());
        GLASS_VIAL = NTItems.registerItem("glass_vial", Item::new, new Item.Properties());
        ELECTROLYTE_ALGAE_SERUM_VIAL = NTItems.registerItem("eas_vial", Item::new, new Item.Properties());
        GRAFTING_TOOL = NTItems.bacteriaItem(NTItems.registerItem("grafting_tool", GraftingToolItem::new, () -> new Item.Properties().durability(80)));
        PETRI_DISH = NTItems.bacteriaItem(NTItems.registerItem("petri_dish", PetriDishItem::new, () -> new Item.Properties().stacksTo(1).component(NTDataComponents.BACTERIA, (Object)ComponentBacteriaStorage.EMPTY)));
        PRISMATIC_BATTERY = NTItems.registerItem("prismatic_battery", BatteryItem::new, new Item.Properties().stacksTo(1));
        PRISM_MONOCLE = NTItems.registerItem("prism_monocle", PrismMonocleItem::new, new Item.Properties().stacksTo(1));
        DIVING_HELMET = NTItems.registerItem("diving_helmet", () -> new DivingSuitArmorItem(NTArmorMaterials.DIVING_SUIT, ArmorItem.Type.HELMET, new Item.Properties()));
        DIVING_CHESTPLATE = NTItems.registerItem("diving_chestplate", () -> new DivingSuitArmorItem(NTArmorMaterials.DIVING_SUIT, ArmorItem.Type.CHESTPLATE, new Item.Properties().component(NTDataComponents.OXYGEN, (Object)0)));
        DIVING_LEGGINGS = NTItems.registerItem("diving_leggings", () -> new DivingSuitArmorItem(NTArmorMaterials.DIVING_SUIT, ArmorItem.Type.LEGGINGS, new Item.Properties()));
        DIVING_BOOTS = NTItems.registerItem("diving_boots", () -> new DivingSuitArmorItem(NTArmorMaterials.DIVING_SUIT, ArmorItem.Type.BOOTS, new Item.Properties()));
        AQUARINE_HELMET = NTItems.registerItem("aquarine_steel_helmet", () -> new AquarineArmorItem(NTArmorMaterials.AQUARINE_STEEL, ArmorItem.Type.HELMET, new Item.Properties()));
        AQUARINE_CHESTPLATE = NTItems.registerItem("aquarine_steel_chestplate", () -> new AquarineArmorItem(NTArmorMaterials.AQUARINE_STEEL, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
        AQUARINE_LEGGINGS = NTItems.registerItem("aquarine_steel_leggings", () -> new AquarineArmorItem(NTArmorMaterials.AQUARINE_STEEL, ArmorItem.Type.LEGGINGS, new Item.Properties()));
        AQUARINE_BOOTS = NTItems.registerItem("aquarine_steel_boots", () -> new AquarineArmorItem(NTArmorMaterials.AQUARINE_STEEL, ArmorItem.Type.BOOTS, new Item.Properties()));
        NEPTUNES_TRIDENT = NTItems.registerItem("neptunes_trident", NeptunesTridentItem::new, new Item.Properties().attributes(NeptunesTridentItem.createAttributes()).component(DataComponents.TOOL, (Object)NeptunesTridentItem.createToolProperties()));
        AQUARINE_SWORD = NTItems.registerItem("aquarine_steel_sword", AquarineSwordItem::new);
        AQUARINE_AXE = NTItems.registerItem("aquarine_steel_axe", AquarineAxeItem::new);
        AQUARINE_HOE = NTItems.registerItem("aquarine_steel_hoe", AquarineHoeItem::new);
        AQUARINE_PICKAXE = NTItems.registerItem("aquarine_steel_pickaxe", AquarinePickaxeItem::new);
        AQUARINE_SHOVEL = NTItems.registerItem("aquarine_steel_shovel", AquarineShovelItem::new);
        AQUARINE_WRENCH = NTItems.registerItem("aquarine_steel_wrench", AquarineWrenchItem::new, new Item.Properties());
        CROWBAR = NTItems.registerItem("crowbar", Item::new, new Item.Properties().stacksTo(1));
        NAUTEC_GUIDE = ModList.get().isLoaded("modonomicon") ? ModonomiconCompat.registerItem() : null;
    }
}

