/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.network;

import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.AugmentationStationBlockEntity;
import com.portingdeadmods.nautec.utils.codec.AugmentCodecs;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record StartAugmentationPayload(BlockPos pos, AugmentSlot slot, UUID playerUUID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StartAugmentationPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"start_augmentation_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StartAugmentationPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StartAugmentationPayload::pos, AugmentCodecs.AUGMENT_SLOT_STREAM_CODEC, StartAugmentationPayload::slot, (StreamCodec)UUIDUtil.STREAM_CODEC, StartAugmentationPayload::playerUUID, StartAugmentationPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void startAugmentation(StartAugmentationPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            BlockEntity be = level.getBlockEntity(payload.pos());
            if (be instanceof AugmentationStationBlockEntity) {
                AugmentationStationBlockEntity asbe = (AugmentationStationBlockEntity)be;
                asbe.startAugmentation(level.getPlayerByUUID(payload.playerUUID), payload.slot());
            }
        });
    }
}

