/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.recipeBuilder;

import com.portingdeadmods.nautec.content.recipes.MixingRecipe;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.datagen.recipeBuilder.NTRecipeBuilder;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MixingRecipeBuilder
implements NTRecipeBuilder {
    private List<IngredientWithCount> ingredients;
    @Nullable
    private FluidStack fluidIngredient;
    private ItemStack result;
    @Nullable
    private FluidStack resultFluid;
    private int duration;

    private MixingRecipeBuilder(ItemStack result) {
        this.result = result;
        this.duration = 120;
    }

    public static MixingRecipeBuilder newRecipe(ItemStack result) {
        return new MixingRecipeBuilder(result);
    }

    public MixingRecipeBuilder ingredients(IngredientWithCount ... ingredients) {
        this.ingredients = List.of(ingredients);
        return this;
    }

    public MixingRecipeBuilder fluidIngredient(@Nullable FluidStack fluidIngredient) {
        this.fluidIngredient = fluidIngredient;
        return this;
    }

    public MixingRecipeBuilder fluidResult(@Nullable FluidStack resultFluid) {
        this.resultFluid = resultFluid;
        return this;
    }

    public MixingRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        MixingRecipe recipe = new MixingRecipe(this.ingredients, this.fluidIngredient != null ? this.fluidIngredient : FluidStack.EMPTY, this.result, this.resultFluid != null ? this.resultFluid : FluidStack.EMPTY, this.duration);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }

    @Override
    public List<Ingredient> getIngredients() {
        return this.ingredients.stream().map(IngredientWithCount::ingredient).toList();
    }

    @Override
    public String getName() {
        return "mixing";
    }
}

