/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.api.fluids.NTFluid;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ItemModelProvider
extends net.neoforged.neoforge.client.model.generators.ItemModelProvider {
    public ItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "nautec", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)NTItems.AQUARINE_STEEL_INGOT.get());
        this.basicItem((Item)NTItems.ATLANTIC_GOLD_INGOT.get());
        this.basicItem((Item)NTItems.ATLANTIC_GOLD_NUGGET.get());
        this.basicItem((Item)NTItems.PRISMARINE_CRYSTAL_SHARD.get());
        this.basicItem((Item)NTItems.PRISMARINE_LENS.get());
        this.basicItem((Item)NTItems.AQUARINE_STEEL_COMPOUND.get());
        this.basicItem((Item)NTItems.CAST_IRON_COMPOUND.get());
        this.basicItem((Item)NTItems.SALT.get());
        this.basicItem((Item)NTItems.AIR_BOTTLE.get());
        this.basicItem((Item)NTItems.ELDRITCH_HEART.get());
        this.basicItem((Item)NTItems.DROWNED_LUNGS.get());
        this.basicItem((Item)NTItems.GUARDIAN_EYE.get());
        this.basicItem((Item)NTItems.DOLPHIN_FIN.get());
        this.basicItem((Item)NTItems.CLAW_ROBOT_ARM.get());
        this.basicItem((Item)NTItems.CAST_IRON_INGOT.get());
        this.basicItem((Item)NTItems.CAST_IRON_NUGGET.get());
        this.basicItem((Item)NTItems.CAST_IRON_ROD.get());
        this.basicItem((Item)NTItems.BROWN_POLYMER.get());
        this.basicItem((Item)NTItems.RUSTY_GEAR.get());
        this.basicItem((Item)NTItems.GEAR.get());
        this.basicItem((Item)NTItems.BROKEN_WHISK.get());
        this.basicItem((Item)NTItems.WHISK.get());
        this.basicItem((Item)NTItems.BURNT_COIL.get());
        this.basicItem((Item)NTItems.LASER_CHANNELING_COIL.get());
        this.basicItem((Item)NTItems.AQUATIC_CHIP.get());
        this.basicItem((Item)NTItems.DAMAGED_AQUATIC_CHIP.get());
        this.basicItem((Item)NTItems.GLASS_VIAL.get());
        this.basicItem((Item)NTItems.ELECTROLYTE_ALGAE_SERUM_VIAL.get());
        this.petriDishItem((Item)NTItems.PETRI_DISH.get());
        this.basicItem((Item)NTItems.PRISM_MONOCLE.get());
        this.basicItem((Item)NTItems.DIVING_HELMET.get());
        this.basicItem((Item)NTItems.DIVING_CHESTPLATE.get());
        this.basicItem((Item)NTItems.DIVING_LEGGINGS.get());
        this.basicItem((Item)NTItems.DIVING_BOOTS.get());
        this.handHeldItem((Item)NTItems.AQUARINE_WRENCH.get());
        this.handHeldItem((Item)NTItems.CROWBAR.get());
        this.handHeldItem((Item)NTItems.GRAFTING_TOOL.get());
        for (NTFluid fluid : NTFluids.HELPER.getFluids()) {
            this.bucket((Fluid)fluid.getStillFluid());
        }
        this.aquarineSteelTool((Item)NTItems.AQUARINE_AXE.get());
        this.aquarineSteelTool((Item)NTItems.AQUARINE_HOE.get());
        this.aquarineSteelTool((Item)NTItems.AQUARINE_PICKAXE.get());
        this.aquarineSteelTool((Item)NTItems.AQUARINE_SHOVEL.get());
        this.aquarineSteelTool((Item)NTItems.AQUARINE_SWORD.get());
        this.basicItem((Item)NTItems.PRISMATIC_BATTERY.get());
        this.basicItem((Item)NTItems.AQUARINE_HELMET.get());
        this.basicItem((Item)NTItems.AQUARINE_CHESTPLATE.get());
        this.basicItem((Item)NTItems.AQUARINE_LEGGINGS.get());
        this.basicItem((Item)NTItems.AQUARINE_BOOTS.get());
        this.parentItemBlock(NTBlocks.LASER_JUNCTION.asItem(), "_base");
        this.blockItems();
    }

    private void bucket(Fluid f) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.key((ItemLike)f.getBucket()).getPath(), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(f);
    }

    @NotNull
    private static ResourceLocation key(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
    }

    private void blockItems() {
        for (Supplier<BlockItem> blockItem : NTItems.BLOCK_ITEMS) {
            this.parentItemBlock((Item)blockItem.get());
        }
    }

    public ItemModelBuilder parentItemBlock(Item item, ResourceLocation loc) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(loc));
    }

    public ItemModelBuilder parentItemBlock(Item item) {
        return this.parentItemBlock(item, "");
    }

    public ItemModelBuilder parentItemBlock(Item item, String suffix) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + suffix))));
    }

    public void petriDishItem(Item item) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation hasBacteria = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"has_bacteria");
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).override().model((ModelFile)this.basicItem(item)).predicate(hasBacteria, 0.0f).end().override().model((ModelFile)this.basicItem(item, "_bacteria").texture("layer1", this.itemTexture(item, "_overlay"))).predicate(hasBacteria, 1.0f).end().texture("layer0", this.itemTexture(item, ""));
    }

    public void aquarineSteelTool(Item item) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation enabled = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled");
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).override().model((ModelFile)this.handHeldItem(item)).predicate(enabled, 0.0f).end().override().model((ModelFile)this.handHeldItem(item, "_enabled")).predicate(enabled, 1.0f).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath())));
    }

    public ItemModelBuilder handHeldItem(Item item) {
        return this.handHeldItem(item, "");
    }

    public ItemModelBuilder handHeldItem(Item item, String suffix) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(location) + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath() + suffix)));
    }

    private ResourceLocation itemTexture(Item item, String suffx) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath() + suffx));
    }

    public ItemModelBuilder basicItem(Item item, String suffix) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString() + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath())));
    }

    private String name(ItemLike item) {
        return ItemModelProvider.key(item).getPath();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }
}

