/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.content.recipes.inputs.MixingRecipeInput;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record MixingRecipe(List<IngredientWithCount> ingredients, FluidStack fluidIngredient, ItemStack result, FluidStack fluidResult, int duration) implements Recipe<MixingRecipeInput>
{
    public static final String NAME = "mixing";

    public MixingRecipe {
        ingredients = ingredients != null ? ingredients : new ArrayList<IngredientWithCount>();
        fluidIngredient = fluidIngredient != null ? fluidIngredient : FluidStack.EMPTY;
        result = result != null ? result : ItemStack.EMPTY;
        fluidResult = fluidResult != null ? fluidResult : FluidStack.EMPTY;
    }

    public boolean matches(@NotNull MixingRecipeInput recipeInput, @NotNull Level level) {
        boolean fluidMatches = recipeInput.fluidStack() != null && !this.fluidIngredient.isEmpty() && recipeInput.fluidStack().is(this.fluidIngredient.getFluid()) && recipeInput.fluidStack().getAmount() >= this.fluidIngredient.getAmount();
        boolean itemsMatch = RecipeUtils.compareItems(recipeInput.items(), this.ingredients);
        return itemsMatch && fluidMatches;
    }

    @NotNull
    public ItemStack assemble(@NotNull MixingRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return RecipeUtils.listToNonNullList(RecipeUtils.iWCToIngredientsSaveCount(this.ingredients));
    }

    @NotNull
    public NonNullList<IngredientWithCount> getIngredientsWithCount() {
        return RecipeUtils.listToNonNullList(this.ingredients);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MixingRecipe)) {
            return false;
        }
        MixingRecipe that = (MixingRecipe)o;
        return this.duration == that.duration && Objects.equals(this.result, that.result) && Objects.equals(this.fluidResult, that.fluidResult) && Objects.equals(this.fluidIngredient, that.fluidIngredient) && Objects.equals(this.ingredients, that.ingredients);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingredients, this.fluidIngredient, this.result, this.fluidResult, this.duration);
    }

    public static class Serializer
    implements RecipeSerializer<MixingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<MixingRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.CODEC.listOf().fieldOf("ingredients").forGetter(MixingRecipe::ingredients), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid_ingredient").forGetter(MixingRecipe::fluidIngredient), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(MixingRecipe::result), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid_result").forGetter(MixingRecipe::fluidResult), (App)Codec.INT.fieldOf("duration").forGetter(MixingRecipe::duration)).apply((Applicative)builder, MixingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)IngredientWithCount.STREAM_CODEC.apply(ByteBufCodecs.list()), MixingRecipe::ingredients, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, MixingRecipe::fluidIngredient, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MixingRecipe::result, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, MixingRecipe::fluidResult, (StreamCodec)ByteBufCodecs.INT, MixingRecipe::duration, MixingRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<MixingRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<MixingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return MixingRecipe.NAME;
        }
    }
}

