/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.content.recipes.inputs.ItemTransformationRecipeInput;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemTransformationRecipe(IngredientWithCount ingredient, ItemStack result, int duration, float purity) implements Recipe<ItemTransformationRecipeInput>
{
    public static final String NAME = "item_transformation";

    public boolean matches(@NotNull ItemTransformationRecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.item()) && this.purity <= recipeInput.purity();
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemTransformationRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{RecipeUtils.iWCToIngredientSaveCount(this.ingredient)});
    }

    public static class Serializer
    implements RecipeSerializer<ItemTransformationRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<ItemTransformationRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.CODEC.fieldOf("ingredient").forGetter(ItemTransformationRecipe::ingredient), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(ItemTransformationRecipe::result), (App)Codec.INT.fieldOf("duration").forGetter(ItemTransformationRecipe::duration), (App)Codec.FLOAT.fieldOf("purity").forGetter(ItemTransformationRecipe::purity)).apply((Applicative)builder, ItemTransformationRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemTransformationRecipe> STREAM_CODEC = StreamCodec.composite(IngredientWithCount.STREAM_CODEC, ItemTransformationRecipe::ingredient, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ItemTransformationRecipe::result, (StreamCodec)ByteBufCodecs.INT, ItemTransformationRecipe::duration, (StreamCodec)ByteBufCodecs.FLOAT, ItemTransformationRecipe::purity, ItemTransformationRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<ItemTransformationRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ItemTransformationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<ItemTransformationRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return ItemTransformationRecipe.NAME;
        }
    }
}

