/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ItemEtchingRecipe(IngredientWithCount ingredient, ItemStack result, int duration) implements Recipe<SingleRecipeInput>
{
    public static final String NAME = "item_etching";

    public boolean matches(@NotNull SingleRecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.item());
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{RecipeUtils.iWCToIngredientSaveCount(this.ingredient)});
    }

    @NotNull
    public NonNullList<IngredientWithCount> getIngredientsWithCount() {
        return NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{this.ingredient});
    }

    public static class Serializer
    implements RecipeSerializer<ItemEtchingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<ItemEtchingRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.CODEC.fieldOf("ingredient").forGetter(ItemEtchingRecipe::ingredient), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(ItemEtchingRecipe::result), (App)Codec.INT.fieldOf("duration").forGetter(ItemEtchingRecipe::duration)).apply((Applicative)builder, ItemEtchingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemEtchingRecipe> STREAM_CODEC = StreamCodec.composite(IngredientWithCount.STREAM_CODEC, ItemEtchingRecipe::ingredient, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ItemEtchingRecipe::result, (StreamCodec)ByteBufCodecs.INT, ItemEtchingRecipe::duration, ItemEtchingRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<ItemEtchingRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ItemEtchingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<ItemEtchingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return ItemEtchingRecipe.NAME;
        }
    }
}

