/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.content.recipes.inputs.BacteriaRecipeInput;
import com.portingdeadmods.nautec.utils.BacteriaHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record BacteriaMutationRecipe(ResourceKey<Bacteria> inputBacteria, ResourceKey<Bacteria> resultBacteria, Ingredient catalyst, float chance) implements Recipe<BacteriaRecipeInput>
{
    public static final String NAME = "bacteria_mutation";
    public static final RecipeType<BacteriaMutationRecipe> TYPE = RecipeType.simple((ResourceLocation)Nautec.rl("bacteria_mutation"));

    public ItemStack getInputDish() {
        return BacteriaHelper.getMaxStatDish(this.inputBacteria, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    public ItemStack getOutputDish() {
        return BacteriaHelper.getMaxStatDish(this.resultBacteria, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    public boolean matches(BacteriaRecipeInput input, Level level) {
        return input.input().is(this.inputBacteria) && this.catalyst.test(input.catalyst());
    }

    public ItemStack assemble(BacteriaRecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public static final class Serializer
    implements RecipeSerializer<BacteriaMutationRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<BacteriaMutationRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Bacteria.BACTERIA_TYPE_CODEC.fieldOf("input_bacteria").forGetter(BacteriaMutationRecipe::inputBacteria), (App)Bacteria.BACTERIA_TYPE_CODEC.fieldOf("result_bacteria").forGetter(BacteriaMutationRecipe::resultBacteria), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(BacteriaMutationRecipe::catalyst), (App)Codec.FLOAT.fieldOf("chance").forGetter(BacteriaMutationRecipe::chance)).apply((Applicative)inst, BacteriaMutationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BacteriaMutationRecipe> STREAM_CODEC = StreamCodec.composite(Bacteria.BACTERIA_TYPE_STREAM_CODEC, BacteriaMutationRecipe::inputBacteria, Bacteria.BACTERIA_TYPE_STREAM_CODEC, BacteriaMutationRecipe::resultBacteria, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, BacteriaMutationRecipe::catalyst, (StreamCodec)ByteBufCodecs.FLOAT, BacteriaMutationRecipe::chance, BacteriaMutationRecipe::new);

        private Serializer() {
        }

        public MapCodec<BacteriaMutationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BacteriaMutationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

