/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.data.NTDataAttachments;
import com.portingdeadmods.nautec.network.ClearAugmentPayload;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClearAugmentsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder nautecCommand = (LiteralArgumentBuilder)Commands.literal((String)"nautec").requires(player -> player.hasPermission(2));
        dispatcher.register((LiteralArgumentBuilder)nautecCommand.then(Commands.literal((String)"augments").then(Commands.literal((String)"clear").executes(ClearAugmentsCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        HashMap<AugmentSlot, Augment> currentAugments = new HashMap<AugmentSlot, Augment>(AugmentHelper.getAugments((Player)player));
        for (Map.Entry entry : currentAugments.entrySet()) {
            Augment augment = (Augment)entry.getValue();
            if (augment == null) continue;
            augment.onRemoved((Player)player);
        }
        player.setData(NTDataAttachments.AUGMENTS, new HashMap());
        player.setData(NTDataAttachments.AUGMENTS_EXTRA_DATA, new HashMap());
        for (AugmentSlot slot : currentAugments.keySet()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClearAugmentPayload(slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        player.sendSystemMessage((Component)Component.literal((String)"Cleared all player augments"));
        return 1;
    }
}

