/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.capabilities.fluid.TwoTankSidedFluidHandler;
import com.portingdeadmods.nautec.content.menus.MixerMenu;
import com.portingdeadmods.nautec.content.recipes.MixingRecipe;
import com.portingdeadmods.nautec.content.recipes.inputs.MixingRecipeInput;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixerBlockEntity
extends LaserBlockEntity
implements MenuProvider {
    public static final int OUTPUT_SLOT = 4;
    public static final Map<@NotNull Direction, @NotNull Pair<IOActions, int[]>> ITEM_HANDLER_SIDED_INTERACTIONS = Map.of(Direction.NORTH, Pair.of((Object)((Object)IOActions.INSERT), (Object)new int[]{0, 1, 2, 3}), Direction.EAST, Pair.of((Object)((Object)IOActions.INSERT), (Object)new int[]{0, 1, 2, 3}), Direction.SOUTH, Pair.of((Object)((Object)IOActions.INSERT), (Object)new int[]{0, 1, 2, 3}), Direction.WEST, Pair.of((Object)((Object)IOActions.INSERT), (Object)new int[]{0, 1, 2, 3}));
    public static final Map<@NotNull Direction, @NotNull Pair<IOActions, int[]>> FLUID_HANDLER_SIDED_INTERACTIONS = Map.of(Direction.NORTH, Pair.of((Object)((Object)IOActions.BOTH), (Object)new int[]{0, 1}), Direction.EAST, Pair.of((Object)((Object)IOActions.BOTH), (Object)new int[]{0, 1}), Direction.SOUTH, Pair.of((Object)((Object)IOActions.BOTH), (Object)new int[]{0, 1}), Direction.WEST, Pair.of((Object)((Object)IOActions.BOTH), (Object)new int[]{0, 1}));
    private boolean running;
    private float independentAngle;
    private float chasingVelocity;
    private int speed;
    private int duration;
    private MixingRecipe recipe;

    public MixerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.MIXER.get(), blockPos, blockState);
        this.addItemHandler(5, (Integer slot, ItemStack stack) -> slot != 4);
        this.addFluidTank(NTConfig.mixerInputCapacity);
        this.addSecondaryFluidTank(NTConfig.mixerOutputCapacity, fluidStack -> false);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object[])Direction.values());
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        if (capability == Capabilities.ItemHandler.BLOCK) {
            return ITEM_HANDLER_SIDED_INTERACTIONS;
        }
        if (capability == Capabilities.FluidHandler.BLOCK) {
            return FLUID_HANDLER_SIDED_INTERACTIONS;
        }
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        this.performRecipe();
        this.speed = this.running ? 20 : 0;
    }

    private void performRecipe() {
        if (this.recipe != null && this.getPower() > NTConfig.mixerPower) {
            this.running = true;
            if (this.duration >= this.recipe.duration()) {
                this.duration = 0;
                this.running = false;
                MixingRecipe currentRecipe = this.recipe;
                this.setOutputs(currentRecipe);
                this.removeInputs(currentRecipe);
                this.recipe = this.getRecipe().orElse(null);
            } else {
                ++this.duration;
            }
        } else {
            this.running = false;
            this.duration = 0;
            this.recipe = null;
        }
    }

    private void removeInputs(MixingRecipe mixingRecipe) {
        if (mixingRecipe == null || mixingRecipe.ingredients().isEmpty()) {
            return;
        }
        IFluidHandler fluidHandler = this.getFluidHandler();
        IItemHandler itemHandler = this.getItemHandler();
        ArrayList<IngredientWithCount> ingredients = new ArrayList<IngredientWithCount>(mixingRecipe.ingredients());
        block0: for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack item = itemHandler.getStackInSlot(i);
            for (IngredientWithCount ingredient : ingredients) {
                if (!ingredient.test(item)) continue;
                itemHandler.extractItem(i, ingredient.count(), false);
                ingredients.remove(ingredient);
                continue block0;
            }
        }
        fluidHandler.drain(mixingRecipe.fluidIngredient().getAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public IFluidHandler getFluidHandlerOnSide(Direction direction) {
        return this.getHandlerOnSide(Capabilities.FluidHandler.BLOCK, (ignored, actionSlotsPair) -> new TwoTankSidedFluidHandler(this.getFluidHandler(), this.getSecondaryFluidHandler(), (Pair<IOActions, int[]>)actionSlotsPair), direction, this.getFluidHandler());
    }

    @Override
    public void onPowerChanged() {
        super.onPowerChanged();
        this.recipe = this.getRecipe().orElse(null);
    }

    private void setOutputs(MixingRecipe mixingRecipe) {
        if (mixingRecipe == null) {
            return;
        }
        ItemStackHandler handler = this.getItemStackHandler();
        int prevCount = handler.getStackInSlot(4).getCount();
        int newCount = mixingRecipe.result().getCount() + prevCount;
        handler.setStackInSlot(4, mixingRecipe.result().copyWithCount(newCount));
        FluidTank tank = this.getSecondaryFluidTank();
        int prevAmount = tank.getFluidAmount();
        int newAmount = mixingRecipe.fluidResult().getAmount() + prevAmount;
        tank.setFluid(mixingRecipe.fluidResult().copyWithAmount(newAmount));
    }

    private Optional<MixingRecipe> getRecipe() {
        IItemHandler itemHandler = this.getItemHandler();
        int slots = itemHandler.getSlots();
        ArrayList<ItemStack> itemHandlerStacksList = new ArrayList<ItemStack>(slots);
        for (int i = 0; i < slots - 1; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            itemHandlerStacksList.add(stack);
        }
        MixingRecipeInput input = new MixingRecipeInput(itemHandlerStacksList, this.getFluidTank().getFluid());
        Optional<MixingRecipe> recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)input, this.level).map(RecipeHolder::value);
        if (recipe.isEmpty() && itemHandlerStacksList.size() > 1) {
            recipe = this.tryRecipeWithSubsets(itemHandlerStacksList);
        }
        if (recipe.isPresent() && this.canInsertItem(recipe.get().result()) && this.canInsertFluid(recipe.get().fluidResult())) {
            return recipe;
        }
        return Optional.empty();
    }

    private Optional<MixingRecipe> tryRecipeWithSubsets(List<ItemStack> allInputs) {
        Optional<MixingRecipe> recipe;
        MixingRecipeInput input;
        for (ItemStack singleInput : allInputs) {
            List<ItemStack> singleInputList = List.of(singleInput);
            input = new MixingRecipeInput(singleInputList, this.getFluidTank().getFluid());
            recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)input, this.level).map(RecipeHolder::value);
            if (!recipe.isPresent()) continue;
            return recipe;
        }
        for (int size = 2; size < allInputs.size(); ++size) {
            for (int start = 0; start <= allInputs.size() - size; ++start) {
                List<ItemStack> subset = allInputs.subList(start, start + size);
                input = new MixingRecipeInput(subset, this.getFluidTank().getFluid());
                recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)input, this.level).map(RecipeHolder::value);
                if (!recipe.isPresent()) continue;
                return recipe;
            }
        }
        return Optional.empty();
    }

    private boolean canInsertItem(ItemStack result) {
        ItemStack stack = this.getItemHandler().getStackInSlot(4);
        boolean itemMatches = result.isEmpty() || stack.isEmpty() || result.is(stack.getItem());
        int stackLimit = stack.isEmpty() ? result.getMaxStackSize() : stack.getMaxStackSize();
        boolean amountMatches = result.getCount() + stack.getCount() <= Math.min(stackLimit, this.getItemHandler().getSlotLimit(4));
        return itemMatches && amountMatches;
    }

    private boolean canInsertFluid(FluidStack fluidStack) {
        boolean fluidMatches = fluidStack.isEmpty() || this.getSecondaryFluidTank().isEmpty() || fluidStack.is(this.getSecondaryFluidTank().getFluid().getFluid());
        int fluidAmount = this.getSecondaryFluidTank().getFluidAmount();
        boolean amountMatches = fluidAmount + fluidStack.getAmount() <= this.getSecondaryFluidTank().getCapacity();
        return fluidMatches && amountMatches;
    }

    public void onLoad() {
        super.onLoad();
        this.recipe = this.getRecipe().orElse(null);
    }

    @Override
    protected void onItemsChanged(int slot) {
        super.onItemsChanged(slot);
        this.recipe = this.getRecipe().orElse(null);
    }

    @Override
    protected void onFluidChanged() {
        super.onFluidChanged();
        this.recipe = this.getRecipe().orElse(null);
    }

    public int getSpeed() {
        return this.speed;
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.duration = tag.getInt("duration");
        this.independentAngle = tag.getFloat("independentAngle");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("duration", this.duration);
        tag.putFloat("independentAngle", this.independentAngle);
    }

    public FluidStack getInputFluid() {
        return this.getFluidTank().getFluid();
    }

    public int getInputFluidAmount() {
        return this.getFluidTank().getFluidAmount();
    }

    public FluidStack getOutputFluid() {
        return this.getSecondaryFluidTank().getFluid();
    }

    public int getOutputFluidAmount() {
        return this.getSecondaryFluidTank().getFluidAmount();
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isActive() {
        return this.running;
    }

    public int getMaxDuration() {
        return this.getRecipe().map(MixingRecipe::duration).orElse(0);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Mixer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new MixerMenu(containerId, playerInventory, this);
    }
}

