/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LaserJunctionBlockEntity
extends LaserBlockEntity {
    private final Set<Direction> inputDirections = new ObjectOpenHashSet();
    private final Set<Direction> outputDirections = new ObjectOpenHashSet();

    public LaserJunctionBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.LASER_JUNCTION.get(), blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return this.inputDirections;
    }

    public String getLaserInputsAsString() {
        Set<Direction> inputs = this.getLaserInputs();
        if (inputs.isEmpty()) {
            return "No inputs";
        }
        return inputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return this.outputDirections;
    }

    public String getLaserOutputsAsString() {
        Set<Direction> outputs = this.getLaserOutputs();
        if (outputs.isEmpty()) {
            return "No outputs";
        }
        return outputs.stream().map(direction -> StringUtils.capitalizeFirstLetter((String)direction.getName())).reduce((a, b) -> a + ", " + b).orElse("");
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        this.transmitPower(this.power);
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveData(tag, registries);
        ListTag inputList = new ListTag();
        for (Direction direction : this.inputDirections) {
            inputList.add((Object)StringTag.valueOf((String)direction.getName()));
        }
        tag.put("InputDirections", (Tag)inputList);
        ListTag outputList = new ListTag();
        for (Direction direction : this.outputDirections) {
            outputList.add((Object)StringTag.valueOf((String)direction.getName()));
        }
        tag.put("OutputDirections", (Tag)outputList);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider registries) {
        Direction direction;
        String directionName;
        int i;
        super.loadData(tag, registries);
        this.inputDirections.clear();
        if (tag.contains("InputDirections")) {
            ListTag inputList = tag.getList("InputDirections", 8);
            for (i = 0; i < inputList.size(); ++i) {
                directionName = inputList.getString(i);
                direction = Direction.byName((String)directionName);
                if (direction == null) continue;
                this.inputDirections.add(direction);
            }
        }
        this.outputDirections.clear();
        if (tag.contains("OutputDirections")) {
            ListTag outputList = tag.getList("OutputDirections", 8);
            for (i = 0; i < outputList.size(); ++i) {
                directionName = outputList.getString(i);
                direction = Direction.byName((String)directionName);
                if (direction == null) continue;
                this.outputDirections.add(direction);
            }
        }
    }
}

