/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.menus.FishingStationMenu;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class FishingStationBlockEntity
extends LaserBlockEntity
implements MenuProvider {
    private boolean running;
    private int progress;
    private float independentAngle;
    private float chasingVelocity;
    private int speed;

    public FishingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.FISHING_STATION.get(), blockPos, blockState);
        this.addItemHandler(15, (Integer slot, ItemStack stack) -> false);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object)Direction.UP, (Object)Direction.DOWN);
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    private boolean canRun() {
        BlockPos start = this.worldPosition.offset(-NTConfig.fisherRadius, -NTConfig.fisherDepth, -NTConfig.fisherRadius);
        BlockPos end = this.worldPosition.offset(NTConfig.fisherRadius, -1, NTConfig.fisherRadius);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
            if (this.level.getBlockState(pos).is(Blocks.WATER)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.getPower() >= NTConfig.fisherLaserLevel) {
            if (this.progress >= NTConfig.fisherRunDuration) {
                this.progress = 0;
                if (!this.level.isClientSide()) {
                    List<ItemStack> items = this.spawnLoot();
                    block0: for (ItemStack stack : items) {
                        for (int i = 0; i < this.getItemHandler().getSlots(); ++i) {
                            ItemStack itemStack = this.forceInsertItem(i, stack.copy(), false);
                            if (itemStack.isEmpty()) continue block0;
                        }
                        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)((float)this.worldPosition.getY() + 0.5f), (double)this.worldPosition.getZ(), (ItemStack)stack.copy());
                    }
                }
            }
            if (this.isRunning()) {
                ++this.progress;
            }
            if (this.level.getGameTime() % 100L == 0L) {
                this.running = this.canRun();
            }
        } else {
            this.running = false;
        }
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        this.speed = this.running ? 100 : 0;
    }

    public int getSpeed() {
        return this.speed;
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    private List<ItemStack> spawnLoot() {
        LootTable lootTable = this.level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
        return lootTable.getRandomItems(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withParameter(LootContextParams.TOOL, (Object)Items.FISHING_ROD.getDefaultInstance()).create(LootContextParamSets.FISHING));
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.independentAngle = tag.getFloat("angle");
        this.progress = tag.getInt("progress");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putFloat("angle", this.independentAngle);
        tag.putInt("progress", this.progress);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Fishing Station");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new FishingStationMenu(containerId, playerInventory, this);
    }
}

