/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.augments;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.network.KeyPressedPayload;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuardianEyeAugment
extends Augment {
    public Vec3 laserFiredPos = null;
    public int timeLeft = 0;
    private Entity targetEntity;
    private float clientLaserTime;

    public GuardianEyeAugment(AugmentSlot augmentSlot) {
        super(NTAugments.GUARDIAN_EYE.get(), augmentSlot);
    }

    @Override
    public void clientTick(PlayerTickEvent.Post event) {
        if (((KeyMapping)NTKeybinds.ACTIVATE_LASER_KEYBIND.get()).isDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new KeyPressedPayload(this.augmentSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.handleKeybindPress();
        }
        if (this.targetEntity != null && !this.targetEntity.isAlive()) {
            this.targetEntity = null;
        }
        if (this.targetEntity != null) {
            this.clientLaserTime = this.clientLaserTime < (float)this.getLaserAnimTimeDuration() ? (this.clientLaserTime += 0.5f) : 0.0f;
            double laserScale = this.getLaserScale(0.0f);
            double dx = this.targetEntity.getX() - this.player.getX();
            double dy = this.targetEntity.getY(0.5) - this.player.getEyeY();
            double dz = this.targetEntity.getZ() - this.player.getZ();
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double nx = dx / dist;
            double ny = dy / dist;
            double nz = dz / dist;
            double rOffset = this.player.getRandom().nextDouble();
            double particleDist = 0.0;
            while (particleDist < dist) {
                this.player.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.player.getX() + nx * (particleDist += 1.8 - laserScale + rOffset * (1.7 - laserScale)), this.player.getEyeY() + ny * particleDist, this.player.getZ() + nz * particleDist, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLaserAnimTimeDuration() {
        return 80;
    }

    public float getClientLaserTime() {
        return this.clientLaserTime;
    }

    public float getLaserScale(float partialTick) {
        return (this.clientLaserTime + partialTick) / (float)this.getLaserAnimTimeDuration();
    }

    @Override
    public void handleKeybindPress() {
        Vec3 look = this.player.getLookAngle();
        Vec3 startPos = this.player.getEyePosition(1.0f);
        double maxDistance = 15.0;
        double step = 0.1;
        for (double t = 0.0; t <= maxDistance; t += step) {
            Vec3 checkPos = startPos.add(look.scale(t));
            List entities = this.player.level().getEntitiesOfClass(LivingEntity.class, new AABB(checkPos.add(-0.5, -0.5, -0.5), checkPos.add(0.5, 0.5, 0.5)));
            for (LivingEntity entity : entities) {
                if (entity == this.player) continue;
                if (!this.player.level().isClientSide) {
                    entity.hurt(entity.damageSources().magic(), (float)NTConfig.guardianAugmentDamage);
                    this.timeLeft = 1000;
                    this.laserFiredPos = entity.getEyePosition();
                }
                this.targetEntity = entity;
                return;
            }
        }
        this.targetEntity = null;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }
}

