/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AquaticCatalystChannelingRecipeCategory
implements IRecipeCategory<AquaticCatalystChannelingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"aquatic_catalyst_channeling");
    public static final RecipeType<AquaticCatalystChannelingRecipe> RECIPE_TYPE = new RecipeType(UID, AquaticCatalystChannelingRecipe.class);
    private final IDrawable icon;
    private final IDrawable background;

    public AquaticCatalystChannelingRecipeCategory(IGuiHelper helper) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        this.background = helper.createBlankDrawable(136, 24 + 4 * 9);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.AQUATIC_CATALYST.get()));
    }

    public RecipeType<AquaticCatalystChannelingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Aquatic Catalyst Channeling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AquaticCatalystChannelingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        int fontSize = 9;
        Component[] text = new Component[]{Component.literal((String)("Power per tick: " + recipe.powerAmount() / recipe.duration() + " AP/t")), Component.literal((String)("Total Power amount: " + recipe.powerAmount() + " AP")), Component.literal((String)("Duration: " + recipe.duration())), Component.literal((String)("Purity: " + recipe.purity()))};
        for (int i = 0; i < text.length; ++i) {
            guiGraphics.drawCenteredString(font, text[i], 66, 18 + i * fontSize, (int)ChatFormatting.WHITE.getColor().byteValue());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AquaticCatalystChannelingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 8, 0).addIngredients((Ingredient)recipe.getIngredients().get(0));
    }
}

