/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.screen;

import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.client.screen.NTMachineScreen;
import com.portingdeadmods.nautec.api.menu.NTMachineMenu;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.BioReactorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class BioReactorScreen
extends NTMachineScreen<BioReactorBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/gui/bio_reactor.png");
    public static final ResourceLocation PROGRESS_ARROW = Nautec.rl("container/bio_reactor/progress_arrow");

    public BioReactorScreen(NTMachineMenu<BioReactorBlockEntity> menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.titleLabelY = 4;
        this.imageHeight = 174;
    }

    @Override
    @NotNull
    public ResourceLocation getBackgroundTexture() {
        return TEXTURE;
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        for (int i = 0; i < 3; ++i) {
            int topPos = this.topPos - 4;
            int progress = ((BioReactorBlockEntity)((NTMachineMenu)this.menu).blockEntity).getProgress(i);
            int progressPercentage = (int)((float)progress / 100.0f * 24.0f);
            pGuiGraphics.blitSprite(PROGRESS_ARROW, 24, 10, 0, 0, this.leftPos + 76, topPos + 20 + i * 22, progressPercentage, 10);
        }
    }
}

