/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.screen;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.client.screen.AugmentationStationDataPanel;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.AugmentationStationBlockEntity;
import com.portingdeadmods.nautec.content.recipes.AugmentationRecipe;
import com.portingdeadmods.nautec.network.StartAugmentationPayload;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;

public class AugmentationStationScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/gui/augment_station.png");
    public static final ResourceLocation SELECTED_SLOT_IN = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/gui/selected_slot_in.png");
    public static final ResourceLocation SELECTED_SLOT_OUT = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/gui/selected_slot_out.png");
    private final int imageWidth;
    private final int imageHeight;
    private final Player player;
    private final AugmentationStationBlockEntity blockEntity;
    private AugmentationStationDataPanel dataPanel;
    private final AugmentationRecipe recipe;

    public AugmentationStationScreen(AugmentationStationBlockEntity blockEntity, Player player, Component title) {
        super(title);
        this.imageWidth = 202;
        this.imageHeight = 160;
        this.player = player;
        this.blockEntity = blockEntity;
        this.recipe = blockEntity.getRecipe().orElse(null);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int width = x + this.imageWidth - 4 - (x + 4);
        int height = y + this.imageHeight - 6 - (y + 16);
        this.dataPanel = new AugmentationStationDataPanel(Minecraft.getInstance(), width / 3 - 10, height - 50, y + 18, x + this.imageWidth - 58);
        this.addRenderableWidget((GuiEventListener)this.dataPanel);
        this.dataPanel.setAugmentSlots(this.recipe != null ? this.recipe.resultAugment().getAugmentSlots() : NTRegistries.AUGMENT_SLOT.stream().toList());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item augmentItem;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int augmentX = x + 24;
        int augmentY = y + 48;
        if (mouseX > augmentX && mouseX < augmentX + 16 && mouseY > augmentY && mouseY < augmentY + 16 && this.recipe != null && (augmentItem = this.recipe.augmentItem()) != Items.AIR) {
            guiGraphics.renderTooltip(this.font, augmentItem.getName(augmentItem.getDefaultInstance()), mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int augmentX = x + 24;
        int augmentY = y + 48;
        if (this.recipe != null) {
            Item augmentItem = this.recipe.augmentItem();
            if (augmentItem != Items.AIR) {
                guiGraphics.renderFakeItem(augmentItem.getDefaultInstance(), augmentX, augmentY);
                guiGraphics.blit(SELECTED_SLOT_IN, augmentX - 4, augmentY - 4, 0.0f, 0.0f, 24, 24, 24, 24);
            } else {
                guiGraphics.blit(SELECTED_SLOT_OUT, augmentX - 4, augmentY - 4, 0.0f, 0.0f, 24, 24, 24, 24);
            }
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Apply"), btn -> {
            this.blockEntity.startAugmentation(this.player, this.dataPanel.getSelectedSlot());
            PacketDistributor.sendToServer((CustomPacketPayload)new StartAugmentationPayload(this.blockEntity.getBlockPos(), this.dataPanel.getSelectedSlot(), this.player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().setScreen(null);
        }).bounds(x + this.imageWidth / 2 - 40, y + this.imageHeight - 55, 50, 15).build());
        int xOffset = 60;
        int yOffset = 20;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(x + xOffset), (int)(y + yOffset), (int)(x + xOffset + 51), (int)(y + 72 + yOffset), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
        this.renderRect(guiGraphics);
        MutableComponent text = Component.literal((String)"Augmentation Station");
        int textWidth = this.minecraft.font.width((FormattedText)text);
        guiGraphics.drawString(this.minecraft.font, (Component)text, x + this.imageWidth / 2 - textWidth / 2 - 14, y + 2, 0x404040, false);
    }

    private void renderRect(GuiGraphics guiGraphics) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int width = x + this.imageWidth - 4 - (x + 4);
        int height = y + this.imageHeight - 6 - (y + 16);
        int minX = x + this.imageWidth - 58;
        Objects.requireNonNull(this.minecraft.font);
        int lineHeight = 9;
        int slotIndex = this.dataPanel.getSelectedSlotIndex();
        int minY = y + 16 + slotIndex * lineHeight;
        if (slotIndex != -1) {
            guiGraphics.fill(minX, minY + 5, minX + width / 3 - 10, minY + lineHeight + 4, FastColor.ARGB32.color((int)150, (int)150, (int)150));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

