/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, BlockStateGenerator> blockstates = new HashMap<ResourceLocation, BlockStateGenerator>();
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    protected final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        this.blockstates.forEach((id, stateGenerator) -> {
            Path path = blockstatePathProvider.json(id);
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)stateGenerator.get()), (Path)path));
        });
        for (Map.Entry<ResourceLocation, Supplier<JsonElement>> e : this.models.entrySet()) {
            ResourceLocation modelId = e.getKey();
            Path path = modelPathProvider.json(modelId);
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)e.getValue().get(), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Productive Bees Blockstate and Model generator";
    }

    protected void registerStatesAndModels() {
        ArrayList completedTypes = new ArrayList();
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (ProductiveBees.includeMod(modid)) {
                strings.forEach((name, type) -> {
                    String string = name = modid.equals("productivebees") ? name : modid + "_" + name;
                    if (!completedTypes.contains(name)) {
                        completedTypes.add(name);
                        Block hive = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("advanced_" + name + "_beehive")));
                        Block box = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("expansion_box_" + name)));
                        BlockstateProvider.generateModels(hive, box, name, type, this.blockstates, this.modelOutput);
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> {
            Block hive = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("advanced_" + style + "_canvas_beehive")));
            Block box = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("expansion_box_" + style + "_canvas")));
            BlockstateProvider.generateModels(hive, box, style + "_canvas", new HiveType(false, "", (String)style, (ItemLike)Items.OAK_PLANKS, null), this.blockstates, this.modelOutput);
        });
        for (DyeColor color : DyeColor.values()) {
            this.generateHoneyModels(color);
        }
    }

    public static void generateModels(Block hive, Block box, String name, HiveType type, Map<ResourceLocation, BlockStateGenerator> blockstates, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        String modId = BuiltInRegistries.BLOCK.getKey((Object)hive).getNamespace();
        ModelTemplate hiveTemplate = BlockstateProvider.getHiveModelTemplate();
        ModelTemplate expansionTemplate = BlockstateProvider.getExpansionModelTemplate();
        TextureMapping textureMap = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.NONE, name, false) : new TextureMapping();
        TextureMapping textureMapUp = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.UP, name, false) : new TextureMapping();
        TextureMapping textureMapDown = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.DOWN, name, false) : new TextureMapping();
        TextureMapping textureMapLeft = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.LEFT, name, false) : new TextureMapping();
        TextureMapping textureMapRight = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.RIGHT, name, false) : new TextureMapping();
        TextureMapping textureMapBack = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.BACK, name, false) : new TextureMapping();
        TextureMapping textureMapHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.NONE, name, true) : new TextureMapping();
        TextureMapping textureMapUpHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.UP, name, true) : new TextureMapping();
        TextureMapping textureMapDownHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.DOWN, name, true) : new TextureMapping();
        TextureMapping textureMapLeftHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.LEFT, name, true) : new TextureMapping();
        TextureMapping textureMapRightHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.RIGHT, name, true) : new TextureMapping();
        TextureMapping textureMapBackHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.BACK, name, true) : new TextureMapping();
        String hiveModelBase = "block/hives/advanced_" + name + "_beehive";
        ResourceLocation singleModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)hiveModelBase), textureMap, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/small"));
        ResourceLocation upModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_up")), textureMapUp, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/up"));
        ResourceLocation downModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_down")), textureMapDown, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/down"));
        ResourceLocation leftModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_left")), textureMapLeft, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/left"));
        ResourceLocation rightModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_right")), textureMapRight, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/right"));
        ResourceLocation backModel = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_back")), textureMapBack, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/back"));
        ResourceLocation singleModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_honey")), textureMapHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/small_honey"));
        ResourceLocation upModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_up_honey")), textureMapUpHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/up_honey"));
        ResourceLocation downModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_down_honey")), textureMapDownHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/down_honey"));
        ResourceLocation leftModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_left_honey")), textureMapLeftHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/left_honey"));
        ResourceLocation rightModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_right_honey")), textureMapRightHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/right_honey"));
        ResourceLocation backModelHoney = type.hasTexture() ? hiveTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(hiveModelBase + "_back_honey")), textureMapBackHoney, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/back_honey"));
        blockstates.put(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("advanced_" + name + "_beehive")), (BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)hive).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant())).with(PropertyDispatch.properties(AdvancedBeehive.EXPANDED, (Property)BlockStateProperties.LEVEL_HONEY).generate((expanded, level) -> switch (expanded) {
            default -> throw new MatchException(null, null);
            case VerticalHive.NONE -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? singleModelHoney : singleModel));
            case VerticalHive.UP -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? upModelHoney : upModel));
            case VerticalHive.DOWN -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? downModelHoney : downModel));
            case VerticalHive.LEFT -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? leftModelHoney : leftModel));
            case VerticalHive.RIGHT -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? rightModelHoney : rightModel));
            case VerticalHive.BACK -> Variant.variant().with(VariantProperties.MODEL, (Object)(level.compareTo(5) >= 0 ? backModelHoney : backModel));
        })));
        BlockstateProvider.getItemTemplate(type.hasTexture() ? ResourceLocation.fromNamespaceAndPath((String)modId, (String)hiveModelBase) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_hive/" + type.style() + "/small"))).create(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/advanced_" + name + "_beehive")), new TextureMapping(), modelOutput);
        TextureMapping expansionTextureMap = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.NONE, name) : new TextureMapping();
        TextureMapping expansionTextureMapUp = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.UP, name) : new TextureMapping();
        TextureMapping expansionTextureMapDown = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.DOWN, name) : new TextureMapping();
        TextureMapping expansionTextureMapLeft = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.LEFT, name) : new TextureMapping();
        TextureMapping expansionTextureMapRight = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.RIGHT, name) : new TextureMapping();
        TextureMapping expansionTextureMapBack = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.BACK, name) : new TextureMapping();
        String boxModelBase = "block/expansion_boxes/expansion_box_" + name;
        ResourceLocation expansionSingleModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)boxModelBase), expansionTextureMap, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/small"));
        ResourceLocation expansionUpModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(boxModelBase + "_up")), expansionTextureMapUp, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/up"));
        ResourceLocation expansionDownModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(boxModelBase + "_down")), expansionTextureMapDown, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/down"));
        ResourceLocation expansionLeftModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(boxModelBase + "_left")), expansionTextureMapLeft, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/left"));
        ResourceLocation expansionRightModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(boxModelBase + "_right")), expansionTextureMapRight, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/right"));
        ResourceLocation expansionBackModel = type.hasTexture() ? expansionTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(boxModelBase + "_back")), expansionTextureMapBack, modelOutput) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/back"));
        blockstates.put(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("expansion_box_" + name)), (BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)box).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant())).with(PropertyDispatch.property(AdvancedBeehive.EXPANDED).generate(expanded -> switch (expanded) {
            default -> throw new MatchException(null, null);
            case VerticalHive.NONE -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionSingleModel);
            case VerticalHive.UP -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionUpModel);
            case VerticalHive.DOWN -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionDownModel);
            case VerticalHive.LEFT -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionLeftModel);
            case VerticalHive.RIGHT -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionRightModel);
            case VerticalHive.BACK -> Variant.variant().with(VariantProperties.MODEL, (Object)expansionBackModel);
        })));
        BlockstateProvider.getItemTemplate(type.hasTexture() ? ResourceLocation.fromNamespaceAndPath((String)modId, (String)boxModelBase) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/tinted_expansion_box/" + type.style() + "/small"))).create(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/expansion_box_" + name)), new TextureMapping(), modelOutput);
    }

    private void generateHoneyModels(DyeColor color) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(color.getSerializedName() + "_petrified_honey"));
        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/petrified_honey/" + color.getSerializedName()));
        Block honey = (Block)BuiltInRegistries.BLOCK.get(id);
        ModelTemplate modelTemplate = BlockstateProvider.getHoneyBlockModelTemplate();
        modelTemplate.create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/petrified_honey/" + color.getSerializedName())), this.getHoneyBlockTextureMap(color), this.modelOutput, (rLoc, textureMap) -> {
            JsonObject json = modelTemplate.createBaseTemplate(rLoc, textureMap);
            json.addProperty("render_type", "translucent");
            return json;
        });
        this.blockstates.put(id, (BlockStateGenerator)BlockstateProvider.createSimpleBlock(honey, modelLocation));
        BlockstateProvider.getItemTemplate(modelLocation).create(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("item/" + id.getPath())), new TextureMapping(), this.modelOutput);
    }

    public static TextureMapping getHiveTextureMap(VerticalHive expand, String type, boolean hasHoney) {
        ResourceLocation top;
        ResourceLocation front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_front" + (hasHoney ? "_honey" : "")));
        ResourceLocation back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation bottom = top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end"));
        switch (expand) {
            case UP: 
            case DOWN: {
                front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_front_" + String.valueOf((Object)expand) + (hasHoney ? "_honey" : "")));
                right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand)));
                left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand)));
                back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand)));
                break;
            }
            case LEFT: 
            case RIGHT: {
                front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_front_" + String.valueOf((Object)expand.opposite()) + (hasHoney ? "_honey" : "")));
                back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand)));
                bottom = top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_" + String.valueOf((Object)expand)));
                break;
            }
            case BACK: {
                right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_left"));
                left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_right"));
                top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_front"));
                bottom = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_back"));
            }
        }
        return new TextureMapping().put(TextureSlot.EAST, right).put(TextureSlot.WEST, left).put(TextureSlot.FRONT, front).put(TextureSlot.TOP, top).put(TextureSlot.BOTTOM, bottom).put(TextureSlot.BACK, back).copySlot(TextureSlot.EAST, TextureSlot.PARTICLE);
    }

    public static TextureMapping getExpansionTextureMap(VerticalHive expand, String type) {
        ResourceLocation top;
        ResourceLocation front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side"));
        ResourceLocation bottom = top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end"));
        switch (expand) {
            case UP: 
            case DOWN: {
                front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand.opposite())));
                left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand.opposite())));
                right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand.opposite())));
                back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand.opposite())));
                break;
            }
            case LEFT: 
            case RIGHT: {
                front = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand)));
                back = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_" + String.valueOf((Object)expand.opposite())));
                bottom = top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_" + String.valueOf((Object)expand.opposite())));
                break;
            }
            case BACK: {
                left = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_left"));
                right = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_side_right"));
                top = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_back"));
                bottom = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/advanced_beehive/" + type + "_beehive_end_front"));
            }
        }
        return new TextureMapping().put(TextureSlot.EAST, right).put(TextureSlot.WEST, left).put(TextureSlot.FRONT, front).put(TextureSlot.TOP, top).put(TextureSlot.BOTTOM, bottom).put(TextureSlot.BACK, back).copySlot(TextureSlot.EAST, TextureSlot.PARTICLE);
    }

    private TextureMapping getHoneyBlockTextureMap(DyeColor color) {
        return new TextureMapping().put(TextureSlot.UP, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/petrified_honey/" + color.getSerializedName() + "_top"))).put(TextureSlot.DOWN, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/petrified_honey/" + color.getSerializedName() + "_bottom"))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("block/petrified_honey/" + color.getSerializedName() + "_side"))).copySlot(TextureSlot.UP, TextureSlot.PARTICLE);
    }

    public static ModelTemplate getHiveModelTemplate() {
        return new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block/advanced_beehive_template")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.EAST, TextureSlot.WEST, TextureSlot.FRONT, TextureSlot.BACK});
    }

    public static ModelTemplate getExpansionModelTemplate() {
        return new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block/expansion_box_template")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.EAST, TextureSlot.WEST, TextureSlot.FRONT, TextureSlot.BACK});
    }

    public static ModelTemplate getHoneyBlockModelTemplate() {
        return new ModelTemplate(Optional.of(ResourceLocation.withDefaultNamespace((String)"block/honey_block")), Optional.empty(), new TextureSlot[]{TextureSlot.DOWN, TextureSlot.UP, TextureSlot.SIDE, TextureSlot.PARTICLE});
    }

    public static ModelTemplate getItemTemplate(ResourceLocation parent) {
        return new ModelTemplate(Optional.of(parent), Optional.empty(), new TextureSlot[0]);
    }

    public static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation id) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)id));
    }

    private String capName(String name) {
        CharSequence[] nameParts = name.split("_");
        for (int i = 0; i < nameParts.length; ++i) {
            nameParts[i] = ((String)nameParts[i]).substring(0, 1).toUpperCase() + ((String)nameParts[i]).substring(1);
        }
        return String.join((CharSequence)" ", nameParts);
    }
}

