/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.util.FluidContainerUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;

public class HoneyGeneratorScreen
extends AbstractContainerScreen<HoneyGeneratorContainer> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/honey_generator.png");

    public HoneyGeneratorScreen(HoneyGeneratorContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, -5, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, -5, this.getYSize() - 96 + 2, 0x404040, false);
        FluidStack fluidStack = ((HoneyGeneratorContainer)this.menu).tileEntity.fluidHandler.getFluidInTank(0);
        if (this.isHovering(129, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            if (fluidStack.getAmount() > 0) {
                tooltipList.add(Component.translatable((String)"productivebees.screen.fluid_level", (Object[])new Object[]{fluidStack.getHoverName().getString(), fluidStack.getAmount() + "mB"}).getVisualOrderText());
            } else {
                tooltipList.add(Component.translatable((String)"productivebees.screen.empty").getVisualOrderText());
            }
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        int energyAmount = ((HoneyGeneratorContainer)this.menu).tileEntity.energyHandler.getEnergyStored();
        if (this.isHovering(-5, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            tooltipList.add(Component.translatable((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 13, this.getGuiTop(), 0, 0, this.getXSize() + 26, this.getYSize());
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 5, this.getGuiTop() + 17, 206, 0, 4, 52);
        float energyAmount = ((HoneyGeneratorContainer)this.menu).tileEntity.energyHandler.getEnergyStored();
        int energyLevel = (int)(energyAmount * (52.0f / (float)((HoneyGeneratorContainer)this.menu).tileEntity.energyHandler.getMaxEnergyStored()));
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 5, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
        FluidStack fluidStack = ((HoneyGeneratorContainer)this.menu).tileEntity.fluidHandler.getFluidInTank(0);
        if (fluidStack.getAmount() > 0) {
            FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, ((HoneyGeneratorContainer)this.menu).tileEntity.fluidHandler.getTankCapacity(0), 127, 17, 4, 52, 0);
        }
    }
}

