/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.common.block.entity.HoneyGeneratorBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class HoneyGeneratorContainer
extends AbstractContainer {
    public final HoneyGeneratorBlockEntity tileEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public HoneyGeneratorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, HoneyGeneratorContainer.getTileEntity(playerInventory, data));
    }

    public HoneyGeneratorContainer(int windowId, Inventory playerInventory, HoneyGeneratorBlockEntity tileEntity) {
        this((MenuType)ModContainerTypes.HONEY_GENERATOR.get(), windowId, playerInventory, tileEntity);
    }

    public HoneyGeneratorContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, final HoneyGeneratorBlockEntity tileEntity) {
        super(type, windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return tileEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (tileEntity.energyHandler.getEnergyStored() > 0) {
                    tileEntity.energyHandler.extractEnergy(tileEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    tileEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                return i == 0 ? tileEntity.fluidId : tileEntity.fluidHandler.getFluidInTank(0).getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        tileEntity.fluidId = value;
                    }
                    case 1: {
                        FluidStack fluid = tileEntity.fluidHandler.getFluidInTank(0);
                        if (fluid.isEmpty()) {
                            tileEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(tileEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            break;
                        }
                        fluid.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)tileEntity.inventoryHandler, 0, 139, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)tileEntity.inventoryHandler, 1, 139, 53));
        this.addSlotBox((IItemHandler)this.tileEntity.getUpgradeHandler(), 0, 165, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static HoneyGeneratorBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof HoneyGeneratorBlockEntity) {
            return (HoneyGeneratorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof HoneyGenerator && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.tileEntity;
    }
}

