/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Honeycomb
extends HoneycombItem {
    private final int color;

    public Honeycomb(Item.Properties properties, String colorCode) {
        super(properties);
        this.color = ((TextColor)TextColor.parseColor((String)colorCode).result().get()).getValue();
    }

    public int getColor() {
        return this.color;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        CompoundTag nbt;
        ResourceLocation type = (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE);
        if (type != null && (nbt = BeeReloadListener.INSTANCE.getData(type)) != null) {
            return tintIndex == 0 ? nbt.getInt("primaryColor") : nbt.getInt("tertiaryColor");
        }
        return this.getColor();
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        CompoundTag nbt;
        ResourceLocation type = (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE);
        if (type != null && (nbt = BeeReloadListener.INSTANCE.getData(type)) != null) {
            String name = Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(type) + "_bee")).getString();
            return Component.translatable((String)"item.productivebees.honeycomb_configurable", (Object[])new Object[]{name.endsWith(" Bee") ? name.replace(" Bee", "") : name});
        }
        return super.getName(stack);
    }
}

