/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.ingredient;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BeeRenderer {
    public static void render(GuiGraphics guiGraphics, BeeIngredient beeIngredient, Minecraft minecraft) {
        BeeRenderer.render(guiGraphics, 0, 0, beeIngredient, minecraft);
    }

    public static void render(GuiGraphics guiGraphics, int xPosition, int yPosition, BeeIngredient beeIngredient, Minecraft minecraft) {
        Entity bee = beeIngredient.getCachedEntity((Level)minecraft.level);
        if (minecraft.player != null && bee != null) {
            if (bee instanceof ConfigurableBee) {
                ConfigurableBee cBee = (ConfigurableBee)bee;
                cBee.setBeeType(beeIngredient.getBeeType().toString());
            }
            float scaledSize = 18.0f;
            if (bee instanceof ProductiveBee) {
                ProductiveBee pBee = (ProductiveBee)bee;
                pBee.setRenderStatic();
                if (pBee.getSizeModifier() >= 3.0f) {
                    scaledSize = 4.0f;
                }
            }
            bee.tickCount = minecraft.player.tickCount;
            bee.setYBodyRot(-20.0f);
            PoseStack postStack = guiGraphics.pose();
            postStack.pushPose();
            postStack.translate(7.0 + (double)xPosition, 12.0 + (double)yPosition, 1.5);
            postStack.mulPose(Axis.ZP.rotationDegrees(190.0f));
            postStack.mulPose(Axis.YP.rotationDegrees(20.0f));
            postStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            postStack.translate(0.0f, -0.2f, 1.0f);
            postStack.scale(scaledSize, scaledSize, scaledSize);
            EntityRenderDispatcher entityRendererManager = minecraft.getEntityRenderDispatcher();
            MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
            entityRendererManager.render(bee, 0.0, 0.0, 0.0, (float)minecraft.getFrameTimeNs(), 1.0f, postStack, (MultiBufferSource)buffer, 0xF000F0);
            postStack.popPose();
        }
    }
}

