/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class AmberBlockEntityRenderer
implements BlockEntityRenderer<AmberBlockEntity> {
    public AmberBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AmberBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Entity entity;
        if (((Boolean)ProductiveBeesConfig.CLIENT.renderEntitiesInAmber.get()).booleanValue() && (entity = tileEntityIn.getCachedEntity()) != null) {
            AmberBlockEntityRenderer.renderEntity(tileEntityIn, entity, matrixStack, combinedLightIn);
        }
    }

    public static void renderEntity(AmberBlockEntity tileEntityIn, Entity entity, PoseStack matrixStack, int combinedLightIn) {
        float angle = 0.0f;
        if (tileEntityIn.getLevel() != null) {
            Direction facing = (Direction)tileEntityIn.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            if (facing == Direction.NORTH) {
                angle = 180.0f;
            } else if (facing == Direction.SOUTH) {
                angle = 0.0f;
            } else if (facing == Direction.EAST) {
                angle = 90.0f;
            } else if (facing == Direction.WEST) {
                angle = 270.0f;
            }
        }
        float f = 0.72f;
        float f1 = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if ((double)f1 > 1.5) {
            f /= f1 / 2.0f;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.0f, 0.5f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(angle));
        matrixStack.scale(f, f, f);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        entityRenderDispatcher.setRenderShadow(false);
        entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, (float)Minecraft.getInstance().getFrameTimeNs(), 1.0f, matrixStack, (MultiBufferSource)buffer, combinedLightIn);
        matrixStack.popPose();
    }
}

