/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.helper;

import com.google.common.collect.Streams;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.item.AmberItem;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.BeeFloweringRecipe;
import cy.jdkdigital.productivebees.common.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class RecipeHelper {
    public static List<BeeFloweringRecipe> getFlowersRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<BeeFloweringRecipe> recipes = new ArrayList<BeeFloweringRecipe>();
        HashMap<String, TagKey<Block>> flowering = new HashMap<String, TagKey<Block>>();
        flowering.put("productivebees:blue_banded_bee", ModTags.RIVER_FLOWERS);
        flowering.put("productivebees:green_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:nomad_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:chocolate_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:ashy_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:reed_bee", ModTags.SWAMP_FLOWERS);
        flowering.put("productivebees:resin_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:sweat_bee", ModTags.SNOW_FLOWERS);
        flowering.put("productivebees:yellow_black_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:lumber_bee", ModTags.LUMBER);
        flowering.put("productivebees:quarry_bee", ModTags.QUARRY);
        flowering.put("productivebees:creeper_bee", ModTags.POWDERY);
        TagKey<Block> defaultBlockTag = ModTags.DEFAULT_FLOWERING_BLOCK;
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            if (entry.getValue().isConfigurable()) {
                TagKey<EntityType<?>> flowerTag;
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getValue().getBeeType());
                if (nbt.getString("flowerType").equals("entity_types")) {
                    if (!nbt.contains("flowerTag")) continue;
                    flowerTag = ModTags.getEntityTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                    List<EntityType> entityTypeList = Streams.stream((Iterable)BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(flowerTag)).map(Holder::value).toList();
                    entityTypeList.forEach(entityType -> recipes.add(BeeFloweringRecipe.createItem(RecipeHelper.id(((BeeIngredient)entry.getValue()).getBeeType().getPath() + "_" + entityType.getDescriptionId().replace(".", "")), AmberItem.getFakeAmberItem(entityType), (BeeIngredient)entry.getValue())));
                    continue;
                }
                if (nbt.contains("flowerTag")) {
                    flowerTag = ModTags.getBlockTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                    TagKey<Item> itemFlowerTag = ModTags.getItemTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                    recipes.add(BeeFloweringRecipe.createBlock(RecipeHelper.id(entry.getValue().getBeeType().getPath()), flowerTag, itemFlowerTag, entry.getValue()));
                    continue;
                }
                if (nbt.contains("flowerBlock")) {
                    Block flowerBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("flowerBlock")));
                    if (flowerBlock == null || flowerBlock.equals(Blocks.AIR)) continue;
                    recipes.add(BeeFloweringRecipe.createBlock(RecipeHelper.id(entry.getValue().getBeeType().getPath()), flowerBlock, entry.getValue()));
                    continue;
                }
                if (nbt.contains("flowerFluid")) {
                    TagKey<Fluid> flowerFluid;
                    if (nbt.getString("flowerFluid").contains("#")) {
                        flowerFluid = ModTags.getFluidTag(ResourceLocation.parse((String)nbt.getString("flowerFluid").replace("#", "")));
                        recipes.add(BeeFloweringRecipe.createFluid(RecipeHelper.id(entry.getValue().getBeeType().getPath()), flowerFluid, entry.getValue()));
                        continue;
                    }
                    flowerFluid = (TagKey<Fluid>)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("flowerFluid")));
                    recipes.add(BeeFloweringRecipe.createFluid(RecipeHelper.id(entry.getValue().getBeeType().getPath()), flowerFluid, entry.getValue()));
                    continue;
                }
                if (nbt.contains("flowerItem")) {
                    Item flowerItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("flowerItem")));
                    recipes.add(BeeFloweringRecipe.createItem(RecipeHelper.id(entry.getValue().getBeeType().getPath()), new ItemStack((ItemLike)flowerItem), entry.getValue()));
                    continue;
                }
                recipes.add(BeeFloweringRecipe.createBlock(RecipeHelper.id(entry.getValue().getBeeType().getPath()), defaultBlockTag, null, entry.getValue()));
                continue;
            }
            if (entry.getValue().getBeeType().toString().equals("productivebees:rancher_bee")) {
                List<EntityType> entityTypeList = Streams.stream((Iterable)BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(ModTags.RANCHABLES)).map(Holder::value).toList();
                entityTypeList.forEach(entityType -> recipes.add(BeeFloweringRecipe.createItem(RecipeHelper.id(((BeeIngredient)entry.getValue()).getBeeType().getPath() + "_" + entityType.getDescriptionId().replace(".", "")), AmberItem.getFakeAmberItem(entityType), (BeeIngredient)entry.getValue())));
                continue;
            }
            if (flowering.containsKey(entry.getValue().getBeeType().toString())) {
                TagKey blockTag = (TagKey)flowering.get(entry.getValue().getBeeType().toString());
                recipes.add(BeeFloweringRecipe.createBlock(RecipeHelper.id(entry.getValue().getBeeType().getPath()), (TagKey<Block>)blockTag, null, entry.getValue()));
                continue;
            }
            recipes.add(BeeFloweringRecipe.createBlock(RecipeHelper.id(entry.getValue().getBeeType().getPath()), defaultBlockTag, null, entry.getValue()));
        }
        return recipes;
    }

    public static List<RecipeHolder<IncubationRecipe>> getRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<RecipeHolder<IncubationRecipe>> recipes = new ArrayList<RecipeHolder<IncubationRecipe>>();
        if (Minecraft.getInstance().level != null) {
            Bee bee = (Bee)EntityType.BEE.create((Level)Minecraft.getInstance().level);
            Bee baBee = (Bee)EntityType.BEE.create((Level)Minecraft.getInstance().level);
            if (bee != null && baBee != null) {
                ItemStack cage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
                ItemStack babeeCage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
                baBee.setAge(-24000);
                BeeCage.captureEntity(bee, cage);
                BeeCage.captureEntity(baBee, babeeCage);
                ItemStack treats = new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), ((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
                recipes.add((RecipeHolder<IncubationRecipe>)new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"/babee_incubation"), (Recipe)new IncubationRecipe(DataComponentIngredient.of((boolean)false, (ItemStack)babeeCage), Ingredient.of((ItemStack[])new ItemStack[]{treats}), cage, 300)));
            }
            for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
                ItemStack spawnEgg = BeeCreator.getSpawnEgg(ResourceLocation.parse((String)entry.getKey()));
                Ingredient treat = DataComponentIngredient.of((boolean)false, (ItemStack)HoneyTreat.getTypeStack(entry.getKey(), 100));
                recipes.add((RecipeHolder<IncubationRecipe>)new RecipeHolder(ResourceLocation.parse((String)entry.getKey()).withPath(p -> "/" + p + "_incubation"), (Recipe)new IncubationRecipe(Ingredient.of((TagKey)Tags.Items.EGGS), treat, spawnEgg, 300)));
            }
        }
        return recipes;
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)name);
    }
}

