/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.util;

import com.mrbysco.rainshield.block.RainShieldBlock;
import com.mrbysco.rainshield.config.RainShieldConfig;
import com.mrbysco.rainshield.handler.SyncHandler;
import com.mrbysco.rainshield.network.payloads.SyncShieldMapPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public class RainShieldData
extends SavedData {
    private static final String DATA_NAME = "rainshield_world_data";
    public static Map<ResourceLocation, List<BlockPos>> rainShieldMap = new HashMap<ResourceLocation, List<BlockPos>>();

    public RainShieldData(Map<ResourceLocation, List<BlockPos>> rainShieldMap) {
        RainShieldData.rainShieldMap = rainShieldMap;
    }

    public RainShieldData() {
        this(new HashMap<ResourceLocation, List<BlockPos>>());
    }

    public static void addRainShieldPos(BlockPos pos, Level level) {
        ResourceLocation dimensionLocation = level.dimension().location();
        List blockPositions = rainShieldMap.getOrDefault(dimensionLocation, new ArrayList());
        blockPositions.add(pos);
        rainShieldMap.put(dimensionLocation, blockPositions);
        if (!level.isClientSide) {
            RainShieldData data = RainShieldData.get(level);
            data.setDirty(true);
            ((ServerLevel)level).players().forEach(SyncHandler::syncShieldMap);
        }
    }

    public static void removeRainShieldPos(BlockPos pos, Level level) {
        ResourceLocation dimensionLocation = level.dimension().location();
        List blockPositions = rainShieldMap.getOrDefault(dimensionLocation, new ArrayList());
        if (!blockPositions.isEmpty()) {
            blockPositions.removeIf(position -> position.equals((Object)pos));
            rainShieldMap.put(dimensionLocation, blockPositions);
            if (!level.isClientSide) {
                RainShieldData data = RainShieldData.get(level);
                data.setDirty(true);
            }
        }
    }

    public static boolean cancelRain(Level level, BlockPos pos) {
        ResourceLocation dimensionLocation;
        if (level != null && rainShieldMap.containsKey(dimensionLocation = level.dimension().location())) {
            List<BlockPos> blockPositions = rainShieldMap.get(dimensionLocation);
            for (BlockPos shieldPos : blockPositions) {
                BlockState state;
                double distance;
                if (!level.isAreaLoaded(shieldPos, 1) || !((distance = (double)pos.distManhattan((Vec3i)shieldPos)) <= (double)((Integer)RainShieldConfig.CLIENT.rainShieldDistance.get()).intValue()) || !((state = level.getBlockState(shieldPos)).getBlock() instanceof RainShieldBlock) || ((Boolean)state.getValue((Property)RainShieldBlock.POWERED)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static RainShieldData load(CompoundTag tag, HolderLookup.Provider registries) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncShieldMapPayload(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ListTag rainShieldMap = tag.getList("RainShieldMap", 10);
        HashMap<ResourceLocation, List<BlockPos>> shieldMap = new HashMap<ResourceLocation, List<BlockPos>>();
        for (int i = 0; i < rainShieldMap.size(); ++i) {
            CompoundTag listTag = rainShieldMap.getCompound(i);
            String dimension = listTag.getString("Dimension");
            ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)dimension);
            ArrayList<BlockPos> blockPositionsList = new ArrayList<BlockPos>();
            ListTag blockPositions = listTag.getList("BlockPositions", 10);
            for (int j = 0; j < blockPositions.size(); ++j) {
                CompoundTag blockPosTag = blockPositions.getCompound(j);
                BlockPos pos = BlockPos.of((long)blockPosTag.getLong("BlockPos"));
                blockPositionsList.add(pos);
            }
            shieldMap.put(dimensionLocation, blockPositionsList);
        }
        return new RainShieldData(shieldMap);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag rainShieldList = new ListTag();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : rainShieldMap.entrySet()) {
            CompoundTag shieldTag = new CompoundTag();
            shieldTag.putString("Dimension", entry.getKey().toString());
            ListTag blockPositions = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                CompoundTag blockPosTag = new CompoundTag();
                blockPosTag.putLong("BlockPos", pos.asLong());
                blockPositions.add((Object)blockPosTag);
            }
            shieldTag.put("BlockPositions", (Tag)blockPositions);
            rainShieldList.add((Object)shieldTag);
        }
        tag.put("RainShieldMap", (Tag)rainShieldList);
        return tag;
    }

    public static RainShieldData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client level. This is wrong.");
        }
        ServerLevel overworld = level.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (RainShieldData)storage.computeIfAbsent(new SavedData.Factory(RainShieldData::new, RainShieldData::load), DATA_NAME);
    }
}

