/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate.normal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.client.NormalGateClient;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.entity.NormalGatewayEntity;
import dev.shadowsoffire.gateways.gate.BossEventSettings;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public record NormalGateway(Gateway.Size size, TextColor color, List<Wave> waves, List<Reward> rewards, List<Failure> failures, SpawnAlgorithms.SpawnAlgorithm spawnAlgo, GateRules rules, BossEventSettings bossSettings) implements Gateway
{
    public static Codec<NormalGateway> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Gateway.Size.CODEC.fieldOf("size").forGetter(NormalGateway::size), (App)TextColor.CODEC.fieldOf("color").forGetter(NormalGateway::color), (App)Wave.CODEC.listOf().fieldOf("waves").forGetter(NormalGateway::waves), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(NormalGateway::rewards), (App)Failure.CODEC.listOf().optionalFieldOf("failures", Collections.emptyList()).forGetter(NormalGateway::failures), (App)SpawnAlgorithms.CODEC.optionalFieldOf("spawn_algorithm", (Object)SpawnAlgorithms.OPEN_FIELD).forGetter(NormalGateway::spawnAlgo), (App)GateRules.CODEC.optionalFieldOf("rules", (Object)GateRules.DEFAULT).forGetter(NormalGateway::rules), (App)BossEventSettings.CODEC.optionalFieldOf("boss_event", (Object)BossEventSettings.DEFAULT).forGetter(NormalGateway::bossSettings)).apply((Applicative)inst, NormalGateway::new));

    @Override
    public GatewayEntity createEntity(Level level, Player summoner) {
        return new NormalGatewayEntity(level, summoner, (DynamicHolder<Gateway>)GatewayRegistry.INSTANCE.holder(this));
    }

    @Override
    public void appendPearlTooltip(Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flag) {
        NormalGateClient.appendPearlTooltip(this, ctx, tooltips, flag);
    }

    @Override
    public void renderBossBar(GatewayEntity gate, Object gfx, int x, int y, boolean isInWorld) {
        NormalGateClient.renderBossBar(gate, gfx, x, y, isInWorld);
    }

    public int getNumWaves() {
        return this.waves.size();
    }

    public Wave getWave(int n) {
        return this.waves.get(n);
    }

    public Codec<NormalGateway> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Gateway.Size size;
        private TextColor color;
        private final List<Wave> waves = new ArrayList<Wave>();
        private final List<Reward> rewards = new ArrayList<Reward>();
        private final List<Failure> failures = new ArrayList<Failure>();
        private SpawnAlgorithms.SpawnAlgorithm spawnAlgo = SpawnAlgorithms.OPEN_FIELD;
        private GateRules rules = GateRules.DEFAULT;
        private BossEventSettings bossSettings = BossEventSettings.DEFAULT;

        public Builder size(Gateway.Size size) {
            this.size = size;
            return this;
        }

        public Builder color(TextColor color) {
            this.color = color;
            return this;
        }

        public Builder color(int color) {
            return this.color(TextColor.fromRgb((int)color));
        }

        public Builder wave(Wave wave) {
            this.waves.add(wave);
            return this;
        }

        public Builder wave(UnaryOperator<Wave.Builder> config) {
            return this.wave(((Wave.Builder)config.apply(new Wave.Builder())).build());
        }

        public Builder waves(List<Wave> waves) {
            this.waves.addAll(waves);
            return this;
        }

        public Builder keyReward(Reward reward) {
            this.rewards.add(reward);
            return this;
        }

        public Builder keyRewards(List<Reward> rewards) {
            this.rewards.addAll(rewards);
            return this;
        }

        public Builder failure(Failure failure) {
            this.failures.add(failure);
            return this;
        }

        public Builder failures(List<Failure> failures) {
            this.failures.addAll(failures);
            return this;
        }

        public Builder spawnAlgorithm(SpawnAlgorithms.SpawnAlgorithm spawnAlgo) {
            this.spawnAlgo = spawnAlgo;
            return this;
        }

        public Builder rules(GateRules rules) {
            this.rules = rules;
            return this;
        }

        public Builder bossSettings(BossEventSettings bossSettings) {
            this.bossSettings = bossSettings;
            return this;
        }

        public NormalGateway build() {
            if (this.size == null) {
                throw new IllegalStateException("Gateway size must be specified");
            }
            if (this.color == null) {
                throw new IllegalStateException("Gateway color must be specified");
            }
            if (this.waves.isEmpty()) {
                throw new IllegalStateException("Gateway must have at least one wave");
            }
            return new NormalGateway(this.size, this.color, Collections.unmodifiableList(new ArrayList<Wave>(this.waves)), Collections.unmodifiableList(new ArrayList<Reward>(this.rewards)), Collections.unmodifiableList(new ArrayList<Failure>(this.failures)), this.spawnAlgo, this.rules, this.bossSettings);
        }
    }
}

