/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GatewayCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_TYPE = (ctx, builder) -> SharedSuggestionProvider.suggest(GatewayRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"open_gateway").requires(s -> s.hasPermission(2));
        builder.then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_TYPE).executes(c -> GatewayCommand.openGateway((CommandContext<CommandSourceStack>)c, Vec3Argument.getVec3((CommandContext)c, (String)"pos"), ResourceLocationArgument.getId((CommandContext)c, (String)"type")))));
        builder.then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_TYPE).executes(c -> GatewayCommand.openGateway((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"entity").position(), ResourceLocationArgument.getId((CommandContext)c, (String)"type")))));
        pDispatcher.register(builder);
    }

    public static int openGateway(CommandContext<CommandSourceStack> c, Vec3 pos, ResourceLocation type) {
        try {
            Entity nullableSummoner = ((CommandSourceStack)c.getSource()).getEntity();
            Player summoner = nullableSummoner instanceof Player ? (Player)nullableSummoner : ((CommandSourceStack)c.getSource()).getLevel().getNearestPlayer(pos.x(), pos.y(), pos.z(), 64.0, false);
            DynamicHolder gate = GatewayRegistry.INSTANCE.holder(type);
            if (!gate.isBound()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Unknown Gateway"));
                return -1;
            }
            GatewayEntity entity = ((Gateway)gate.get()).createEntity((Level)((CommandSourceStack)c.getSource()).getLevel(), summoner);
            entity.moveTo(pos);
            ((CommandSourceStack)c.getSource()).getLevel().addFreshEntity((Entity)entity);
            entity.onGateCreated();
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }
}

