/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import com.mojang.brigadier.CommandDispatcher;
import dev.shadowsoffire.gateways.command.GatewayCommand;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;

public class GatewayEvents {
    @SubscribeEvent
    public void commands(RegisterCommandsEvent e) {
        GatewayCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public void teleport(EntityTeleportEvent e) {
        GatewayEntity gate = GatewayEntity.getOwner(e.getEntity());
        if (gate != null && gate.getGateway().rules().failOnOutOfBounds() && gate.distanceToSqr(e.getTargetX(), e.getTargetY(), e.getTargetZ()) >= gate.getGateway().getLeashRangeSq()) {
            e.setTargetX(gate.getX() + 0.5 * (double)gate.getBbWidth());
            e.setTargetY(gate.getY() + 0.5 * (double)gate.getBbHeight());
            e.setTargetZ(gate.getZ() + 0.5 * (double)gate.getBbWidth());
        }
    }

    @SubscribeEvent
    public void convert(LivingConversionEvent.Post e) {
        LivingEntity entity = e.getEntity();
        GatewayEntity gate = GatewayEntity.getOwner((Entity)entity);
        if (gate != null) {
            gate.handleConversion((Entity)entity, e.getOutcome());
        }
    }

    @SubscribeEvent
    public void hurt(LivingIncomingDamageEvent e) {
        GatewayEntity gate = GatewayEntity.getOwner((Entity)e.getEntity());
        if (gate != null) {
            Player p;
            boolean isPlayerDamage;
            Entity entity = e.getSource().getEntity();
            boolean bl = isPlayerDamage = entity instanceof Player && !((p = (Player)entity) instanceof FakePlayer);
            if (!isPlayerDamage && gate.getGateway().rules().playerDamageOnly()) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void despawn(MobDespawnEvent e) {
        if (GatewayEntity.getOwner((Entity)e.getEntity()) != null) {
            e.setResult(MobDespawnEvent.Result.DENY);
        }
    }
}

