/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.shrinking;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.spawn.IRoomSpawnManager;
import dev.compactmods.machines.api.shrinking.component.ShrinkingDeviceConfiguration;
import dev.compactmods.machines.gamerule.CMGameRules;
import dev.compactmods.machines.i18n.RoomTranslations;
import dev.compactmods.machines.i18n.Translations;
import dev.compactmods.machines.room.RoomHelper;
import dev.compactmods.machines.shrinking.Shrinking;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PersonalShrinkingDevice
extends Item {
    public PersonalShrinkingDevice(Item.Properties props) {
        super(props);
    }

    public static ShrinkingDeviceConfiguration config(ItemStack stack) {
        return (ShrinkingDeviceConfiguration)stack.getOrDefault(Shrinking.DataComponents.SHRINKING_CONFIG, (Object)ShrinkingDeviceConfiguration.DEFAULT_CONFIG);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltips, flags);
        tooltips.add(Screen.hasShiftDown() ? Translations.UNBREAKABLE_BLOCK.get() : Translations.HINT_HOLD_SHIFT.get());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)stack);
        }
        ShrinkingDeviceConfiguration config = PersonalShrinkingDevice.config(stack);
        if (CompactDimension.isInServerDimension((LivingEntity)player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                String roomCode = (String)CompactMachines.roomApi().chunkManager().findRoomByChunk(serverPlayer.chunkPosition()).orElseThrow();
                IRoomSpawnManager spawnManager = CompactMachines.roomApi().spawnManager(roomCode);
                spawnManager.setPlayerSpawn(serverPlayer);
                player.displayClientMessage((Component)RoomTranslations.ROOM_SPAWNPOINT_SET.apply((Player)serverPlayer, roomCode), true);
            } else {
                RoomHelper.teleportPlayerOutOfRoom(serverPlayer).thenAccept(result -> {
                    if (result.successful() && world.getGameRules().getBoolean(CMGameRules.DAMAGE_PSD_ITEMS_ON_ROOM_EXIT)) {
                        PersonalShrinkingDevice.handleSuccessfulAtomicShift(stack, serverPlayer, config);
                    }
                });
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static void handleSuccessfulAtomicShift(ItemStack stack, ServerPlayer serverPlayer, ShrinkingDeviceConfiguration config) {
        switch (config.afterUseAction()) {
            case DAMAGE: {
                if (serverPlayer.hasInfiniteMaterials()) break;
                stack.hurtAndBreak(1, serverPlayer.serverLevel(), serverPlayer, item -> {});
                break;
            }
            case BREAK: {
                if (serverPlayer.hasInfiniteMaterials()) break;
                stack.consume(1, (LivingEntity)serverPlayer);
                PlayerUtil.breakItemEffect((Player)serverPlayer, stack);
            }
        }
    }
}

