/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade;

import dev.compactmods.machines.api.room.upgrade.components.RoomUpgradeList;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class RoomUpgradeInventory
extends ItemStackHandler {
    public static final RoomUpgradeInventory EMPTY = new RoomUpgradeInventory();
    private final Int2ObjectMap<UUID> UPGRADE_IDS = new Int2ObjectOpenHashMap();

    public RoomUpgradeInventory() {
        super(9);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return !stack.isEmpty() && stack.has(RoomUpgrades.UPGRADE_LIST_COMPONENT);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        ItemStack acceptedStack = this.getStackInSlot(slot);
        if (acceptedStack.isEmpty()) {
            this.UPGRADE_IDS.remove(slot);
        } else {
            RoomUpgradeList upgrades = (RoomUpgradeList)acceptedStack.get(RoomUpgrades.UPGRADE_LIST_COMPONENT);
            UUID newID = UUID.randomUUID();
            this.UPGRADE_IDS.put(slot, (Object)newID);
        }
    }

    public Stream<ItemStack> items() {
        Stream.Builder<ItemStack> b = Stream.builder();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            b.add(stack);
        }
        return b.build();
    }
}

