/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.components.RoomUpgradeList;
import dev.compactmods.machines.api.room.upgrade.events.lifecycle.UpgradeTickedEventListener;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class RoomUpgradeEventHandlers {
    public static void onLevelTick(LevelTickEvent.Post postTick) {
        ServerLevel serverLevel;
        if (!CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(postTick.getLevel().enabledFeatures())) {
            return;
        }
        Level level = postTick.getLevel();
        if (level instanceof ServerLevel && CompactDimension.isLevelCompact((Level)(serverLevel = (ServerLevel)level))) {
            Set rooms = CompactMachines.roomApi().registrar().allRooms().collect(Collectors.toUnmodifiableSet());
            for (RoomInstance room : rooms) {
                CompactMachines.existingRoomData((String)room.code()).flatMap(rd -> rd.getExistingData(Rooms.DataAttachments.UPGRADE_INV)).ifPresent(appliedUpgrades -> {
                    Set upgradeStacks = appliedUpgrades.items().collect(Collectors.toUnmodifiableSet());
                    for (ItemStack upgradeStack : upgradeStacks) {
                        RoomUpgradeList upgrades = (RoomUpgradeList)upgradeStack.get(RoomUpgrades.UPGRADE_LIST_COMPONENT);
                        upgrades.upgrades().stream().flatMap(ru -> ru.gatherEvents().filter(UpgradeTickedEventListener.class::isInstance)).map(UpgradeTickedEventListener.class::cast).forEach(ticker -> ticker.handle(serverLevel, room, upgradeStack));
                    }
                });
            }
        }
    }

    public static void onTooltips(ItemTooltipEvent evt) {
        Item.TooltipContext ctx = evt.getContext();
        Consumer<Component> tooltips = evt.getToolTip()::add;
        TooltipFlag flags = evt.getFlags();
        ItemStack stack = evt.getItemStack();
        stack.addToTooltip(RoomUpgrades.UPGRADE_LIST_COMPONENT, ctx, tooltips, flags);
    }
}

