/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.ui.upgrades;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.client.render.ConditionalGhostSlot;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.upgrade.RoomUpgradeInventory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class RoomUpgradeMenu
extends AbstractContainerMenu {
    private final Inventory playerInv;
    public final String roomCode;
    public boolean showBackButton = true;
    private boolean standalone = false;

    protected RoomUpgradeMenu(int winId, Inventory playerInv, String roomCode, RoomUpgradeInventory upgradeInv) {
        super((MenuType)Rooms.Menus.ROOM_UPGRADES.get(), winId);
        this.playerInv = playerInv;
        this.roomCode = roomCode;
        for (int slot = 0; slot < 9; ++slot) {
            int slotX = 8 + slot * 18;
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)upgradeInv, slot, slotX, 18){

                public void onTake(Player pPlayer, ItemStack pStack) {
                    super.onTake(pPlayer, pStack);
                }
            });
        }
        int slotY = 69;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new ConditionalGhostSlot((Container)playerInv, j1 + l * 9 + 9, 8 + j1 * 18, l * 18 + slotY));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new ConditionalGhostSlot((Container)playerInv, i1, 8 + i1 * 18, slotY + 54 + 4));
        }
    }

    public ItemStack quickMoveStack(Player player, int pIndex) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clicked(int pSlotId, int pButton, ClickType clickType, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        super.clicked(pSlotId, pButton, clickType, player);
    }

    public static MenuProvider provider(final RoomInstance room) {
        return new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"compactmachines.ui.room_upgrades");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int winId, Inventory inventory, Player player) {
                RoomUpgradeInventory serverUpgInv = (RoomUpgradeInventory)((Object)CompactMachines.roomData((String)room.code()).getData(Rooms.DataAttachments.UPGRADE_INV));
                return new RoomUpgradeMenu(winId, inventory, room.code(), serverUpgInv);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    public static RoomUpgradeMenu createClientMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        boolean isIsolated = extraData.readBoolean();
        String code = extraData.readUtf();
        RoomUpgradeMenu menu = new RoomUpgradeMenu(id, playerInv, code, RoomUpgradeInventory.EMPTY);
        menu.setIsolated(isIsolated);
        return menu;
    }

    private void setIsolated(boolean isolated) {
        this.showBackButton = !isolated;
    }
}

