/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.spawn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.api.room.spatial.IRoomBoundaries;
import dev.compactmods.machines.api.room.spawn.IRoomSpawn;
import dev.compactmods.machines.api.room.spawn.IRoomSpawnManager;
import dev.compactmods.machines.api.room.spawn.IRoomSpawns;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.room.spawn.RoomSpawn;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnManager
implements IRoomSpawnManager,
CodecHolder<SpawnManager>,
CMDataFile {
    private final Logger LOGS = LogManager.getLogger();
    private static final UnboundedMapCodec<UUID, RoomSpawn> PLAYER_SPAWNS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, RoomSpawn.CODEC);
    private static final Codec<SpawnManager> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("roomCode").forGetter(x -> x.roomCode), (App)PLAYER_SPAWNS_CODEC.fieldOf("player_spawns").forGetter(x -> x.playerSpawns), (App)RoomSpawn.CODEC.fieldOf("default_spawn").forGetter(x -> x.defaultSpawn)).apply((Applicative)inst, SpawnManager::new));
    private final String roomCode;
    private RoomSpawn defaultSpawn;
    private final Map<UUID, RoomSpawn> playerSpawns;
    private AABB roomBounds;

    public SpawnManager(String roomCode) {
        this(roomCode, Collections.emptyMap(), null);
        this.defaultSpawn = null;
    }

    public SpawnManager(String roomCode, IRoomBoundaries roomBounds) {
        this(roomCode, Collections.emptyMap(), new RoomSpawn(roomBounds.defaultSpawn(), Vec2.ZERO));
        this.roomBounds = roomBounds.innerBounds();
    }

    public SpawnManager(String roomCode, Map<UUID, RoomSpawn> playerSpawns, RoomSpawn defaultSpawn) {
        this.roomCode = roomCode;
        this.playerSpawns = new HashMap<UUID, RoomSpawn>(playerSpawns);
        this.defaultSpawn = defaultSpawn;
    }

    public void resetPlayerSpawn(UUID player) {
        this.playerSpawns.remove(player);
    }

    public void setDefaultSpawn(Vec3 position, Vec2 rotation) {
        this.defaultSpawn = new RoomSpawn(position, rotation);
    }

    public IRoomSpawns spawns() {
        HashMap<UUID, RoomSpawn> ps = new HashMap<UUID, RoomSpawn>();
        this.playerSpawns.forEach(ps::putIfAbsent);
        return new RoomSpawns(this.defaultSpawn, ps);
    }

    public void setPlayerSpawn(UUID player, Vec3 location, Vec2 rotation) {
        if (!this.roomBounds.contains(location)) {
            return;
        }
        this.playerSpawns.put(player, new RoomSpawn(location, rotation));
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.PLAYER_SPAWNS.apply(server);
    }

    @Override
    public Codec<SpawnManager> codec() {
        return null;
    }

    private static final class RoomSpawns
    extends Record
    implements IRoomSpawns {
        private final RoomSpawn defaultSpawn;
        private final Map<UUID, RoomSpawn> playerSpawnsSnapshot;

        private RoomSpawns(RoomSpawn defaultSpawn, Map<UUID, RoomSpawn> playerSpawnsSnapshot) {
            this.defaultSpawn = defaultSpawn;
            this.playerSpawnsSnapshot = playerSpawnsSnapshot;
        }

        public Optional<IRoomSpawn> forPlayer(UUID player) {
            return Optional.ofNullable((IRoomSpawn)this.playerSpawnsSnapshot.get(player));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RoomSpawns.class, "defaultSpawn;playerSpawnsSnapshot", "defaultSpawn", "playerSpawnsSnapshot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RoomSpawns.class, "defaultSpawn;playerSpawnsSnapshot", "defaultSpawn", "playerSpawnsSnapshot"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RoomSpawns.class, "defaultSpawn;playerSpawnsSnapshot", "defaultSpawn", "playerSpawnsSnapshot"}, this, o);
        }

        public RoomSpawn defaultSpawn() {
            return this.defaultSpawn;
        }

        public Map<UUID, RoomSpawn> playerSpawnsSnapshot() {
            return this.playerSpawnsSnapshot;
        }
    }
}

