/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import com.mojang.serialization.Codec;
import dev.compactmods.feather.MemoryGraph;
import dev.compactmods.feather.node.Node;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.api.room.registration.IRoomBuilder;
import dev.compactmods.machines.api.room.registration.IRoomRegistrar;
import dev.compactmods.machines.api.room.spatial.IRoomBoundaries;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.room.NewRoomBuilder;
import dev.compactmods.machines.room.graph.node.RoomRegistrationNode;
import dev.compactmods.machines.util.MathUtil;
import dev.compactmods.spatial.aabb.AABBAligner;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RoomRegistrar
implements IRoomRegistrar,
CodecHolder<RoomRegistrar>,
CMDataFile {
    public static final Logger LOGS = LogManager.getLogger();
    public static final Codec<RoomRegistrar> CODEC = RoomRegistrationNode.CODEC.listOf().fieldOf("rooms").xmap(RoomRegistrar::new, x -> List.copyOf(x.registrationNodes.values())).codec();
    private final MemoryGraph graph = new MemoryGraph();
    private final Map<String, RoomRegistrationNode> registrationNodes = new HashMap<String, RoomRegistrationNode>();

    public RoomRegistrar() {
    }

    private RoomRegistrar(List<RoomRegistrationNode> regNodes) {
        this();
        regNodes.forEach(this::registerDirty);
    }

    public IRoomBuilder builder() {
        return new NewRoomBuilder();
    }

    public AABB getNextBoundaries(RoomTemplate template) {
        Vec3i region = MathUtil.getRegionPositionByIndex(this.registrationNodes.size());
        Vec3 floor = MathUtil.getCenterWithY(region, 0);
        return AABBAligner.floor((AABB)template.getZeroBoundaries().move(floor), (double)0.0);
    }

    public RoomInstance createNew(RoomTemplate template, UUID owner, Consumer<IRoomBuilder> override) {
        RoomInstance inst = super.createNew(template, owner, override);
        RoomRegistrationNode node = new RoomRegistrationNode(UUID.randomUUID(), new RoomRegistrationNode.Data(inst));
        this.registrationNodes.put(inst.code(), node);
        this.graph.addNode((Node)node);
        CompactMachines.roomApi().chunkManager().calculateChunks(inst.code(), (IRoomBoundaries)node);
        return inst;
    }

    public boolean isRegistered(String room) {
        return this.registrationNodes.containsKey(room);
    }

    public Optional<RoomInstance> get(String room) {
        RoomRegistrationNode regNode = this.registrationNodes.get(room);
        if (regNode == null) {
            return Optional.empty();
        }
        RoomInstance inst = RoomRegistrar.makeRoomInstance(regNode);
        return Optional.of(inst);
    }

    @NotNull
    private static RoomInstance makeRoomInstance(RoomRegistrationNode regNode) {
        return new RoomInstance(regNode.code(), regNode.defaultMachineColor(), (IRoomBoundaries)regNode);
    }

    public long count() {
        return this.registrationNodes.size();
    }

    public Stream<String> allRoomCodes() {
        return this.registrationNodes.keySet().stream();
    }

    public Stream<RoomInstance> allRooms() {
        return this.registrationNodes.values().stream().map(RoomRegistrar::makeRoomInstance);
    }

    private void registerDirty(RoomRegistrationNode node) {
        this.registrationNodes.putIfAbsent(node.code(), node);
        this.graph.addNode((Node)node);
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.DATA_ROOT.apply(server);
    }

    @Override
    public Codec<RoomRegistrar> codec() {
        return CODEC;
    }
}

