/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.item;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.machine.Machines;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BoundCompactMachineItem
extends BlockItem {
    public static final String NBT_ROOM_DIMENSIONS = "room_dimensions";
    private static final String FALLBACK_ID = Util.makeDescriptionId((String)"block", (ResourceLocation)CompactMachines.modRL((String)"bound_machine_fallback"));

    public BoundCompactMachineItem(Item.Properties builder) {
        super((Block)Machines.Blocks.BOUND_MACHINE.get(), builder);
    }

    public Component getName(ItemStack stack) {
        return (Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.translatableWithFallback((String)FALLBACK_ID, (String)"Compact Machine"));
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        return FALLBACK_ID;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flags) {
        super.appendHoverText(stack, ctx, tooltips, flags);
        String roomCode = (String)stack.get(Machines.DataComponents.BOUND_ROOM_CODE);
        if (roomCode != null) {
            tooltips.add((Component)Component.translatableWithFallback((String)MachineTranslations.IDs.BOUND_TO, (String)"Bound To: %s", (Object[])new Object[]{roomCode}));
        }
    }
}

