/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.capability;

import dev.compactmods.machines.api.room.RoomInstance;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MachineCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<MachineCapability<?, ?>> registry = new CapabilityRegistry(MachineCapability::new);
    final Map<String, List<ICapabilityProvider<RoomInstance, C, T>>> providers = new IdentityHashMap<String, List<ICapabilityProvider<RoomInstance, C, T>>>();

    protected MachineCapability(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    private static <T, C> MachineCapability<T, C> create(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        return (MachineCapability)((Object)registry.create(name, typeClass, contextClass));
    }

    public static <T> MachineCapability<T, Void> createVoid(ResourceLocation name, Class<T> typeClass) {
        return MachineCapability.create(name, typeClass, Void.TYPE);
    }

    public static <T> MachineCapability<T, GlobalPos> createMachineUnsided(ResourceLocation name, Class<T> typeClass) {
        return MachineCapability.create(name, typeClass, GlobalPos.class);
    }

    public static <T> MachineCapability<T, GlobalPos> createMachineSided(ResourceLocation name, Class<T> typeClass) {
        return MachineCapability.create(name, typeClass, GlobalPos.class);
    }

    @ApiStatus.Internal
    @Nullable
    public T getCapability(RoomInstance room, C context) {
        for (ICapabilityProvider provider : this.providers.getOrDefault(room.code(), List.of())) {
            Object ret = provider.getCapability((Object)room, context);
            if (ret == null) continue;
            return (T)ret;
        }
        return null;
    }
}

