/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.room;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import java.nio.file.Path;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.attachment.AttachmentHolder;

public class RoomDataAttachments
extends AttachmentHolder
implements CMDataFile,
CodecHolder<RoomDataAttachments> {
    private final String roomCode;
    private final Codec<RoomDataAttachments> codec;

    public RoomDataAttachments(MinecraftServer server, String roomCode) {
        this.roomCode = roomCode;
        this.codec = RoomDataAttachments.makeCodec(server);
    }

    public static Codec<RoomDataAttachments> makeCodec(MinecraftServer server) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("room_code").forGetter(RoomDataAttachments::roomCode), (App)CompoundTag.CODEC.fieldOf("attachments").forGetter(inst -> inst.serializeAttachments((HolderLookup.Provider)server.registryAccess()))).apply((Applicative)i, (roomCode, ct) -> {
            RoomDataAttachments inst = new RoomDataAttachments(server, (String)roomCode);
            inst.deserializeAttachments((HolderLookup.Provider)server.registryAccess(), (CompoundTag)ct);
            return inst;
        }));
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.ROOM_DATA_ATTACHMENTS.apply(server);
    }

    public String roomCode() {
        return this.roomCode;
    }

    @Override
    public Codec<RoomDataAttachments> codec() {
        return this.codec;
    }
}

