/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.manager;

import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.data.DataFileUtil;
import dev.compactmods.machines.data.manager.IKeyedDataFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.IOUtilities;

public class CMKeyedDataFileManager<Key, T extends CMDataFile & CodecHolder<T>>
implements IKeyedDataFileManager<Key, T> {
    protected final MinecraftServer server;
    private final BiFunction<MinecraftServer, Key, T> creator;
    private final HashMap<Key, T> cache;

    public CMKeyedDataFileManager(MinecraftServer server, BiFunction<MinecraftServer, Key, T> creator) {
        this.server = server;
        this.creator = creator;
        this.cache = new HashMap();
    }

    public String getFileKey(Key key) {
        return key.toString();
    }

    @Override
    public T data(Key key) {
        return (T)this.cache.computeIfAbsent(key, k -> {
            CMDataFile inst = (CMDataFile)this.creator.apply(this.server, k);
            Path dir = inst.getDataLocation(this.server);
            DataFileUtil.ensureDirExists(dir);
            File file = dir.resolve(k.toString() + ".dat").toFile();
            return !file.exists() ? inst : (CMDataFile)DataFileUtil.loadFileWithCodec(file, ((CodecHolder)((Object)inst)).codec());
        });
    }

    @Override
    public Optional<T> optionalData(Key key) {
        return this.hasData(key) ? Optional.ofNullable(this.data(key)) : Optional.empty();
    }

    @Override
    public void save() {
        this.cache.forEach((key, data) -> {
            CompoundTag fullData = new CompoundTag();
            fullData.putString("version", data.getDataVersion());
            Tag fileData = (Tag)((CodecHolder)((Object)data)).codec().encodeStart((DynamicOps)NbtOps.INSTANCE, data).getOrThrow();
            fullData.put("data", fileData);
            try {
                IOUtilities.writeNbtCompressed((CompoundTag)fullData, (Path)data.getDataLocation(this.server).resolve(this.getFileKey(key) + ".dat"));
            }
            catch (IOException e) {
                LoggingUtil.modLog().error("Failed to write data: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public boolean hasData(Key key) {
        return this.cache.containsKey(key);
    }
}

