/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.room;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.gander.render.geometry.BakedLevel;
import dev.compactmods.gander.ui.widget.SpatialRenderer;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.shrinking.PSDTags;
import dev.compactmods.machines.client.widget.ImageButtonBuilder;
import dev.compactmods.machines.compat.curios.CuriosCompat;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.network.room.PlayerRequestedTeleportPacket;
import dev.compactmods.machines.network.room.PlayerRequestedUpgradeUIPacket;
import dev.compactmods.machines.network.room.PlayerStartedRoomTrackingPacket;
import dev.compactmods.machines.shrinking.Shrinking;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class MachineRoomScreen
extends Screen {
    private final GlobalPos machinePos;
    private final String roomCode;
    private SpatialRenderer renderer;
    private ImageButton psdButton;
    private ScreenRectangle screenArea;

    public MachineRoomScreen(Component title, GlobalPos machinePos, String roomCode) {
        super(title);
        this.machinePos = machinePos;
        this.roomCode = roomCode;
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerStartedRoomTrackingPacket(roomCode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void init() {
        super.init();
        WidgetSprites psdBtnSprites = new WidgetSprites(CompactMachines.modRL((String)"personal_shrinking_device"), CompactMachines.modRL((String)"personal_shrinking_device_disabled"), CompactMachines.modRL((String)"personal_shrinking_device_highlighted"), CompactMachines.modRL((String)"personal_shrinking_device_disabled"));
        this.screenArea = new ScreenRectangle(this.width / 2 - 130, this.height / 2 - 120, 260, 240);
        this.psdButton = ImageButtonBuilder.button(psdBtnSprites).size(12, 12).location(this.screenArea.right() - 12, this.screenArea.bottom() + 12).onPress(btn -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedTeleportPacket(this.machinePos, this.roomCode), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
        this.addRenderableWidget((GuiEventListener)this.psdButton);
        this.roomUpgradesButton();
    }

    public void tick() {
        super.tick();
        this.psdButton.active = MachineRoomScreen.checkForShrinkingDevice();
    }

    private static boolean checkForShrinkingDevice() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        boolean hasPsdInInv = player.getInventory().contains(slotItem -> slotItem.has(Shrinking.DataComponents.SHRINKING_CONFIG) || slotItem.is(PSDTags.ITEM));
        if (hasPsdInInv) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasPsdCurio((LivingEntity)player);
        }
        return false;
    }

    private void roomUpgradesButton() {
        if (this.minecraft == null || this.minecraft.getConnection() == null) {
            return;
        }
        if (CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(this.minecraft.getConnection().enabledFeatures())) {
            WidgetSprites upgradeBtnSprites = new WidgetSprites(CompactMachines.modRL((String)"upgrade_btn"), CompactMachines.modRL((String)"upgrade_btn"));
            ImageButton upgradeScreenBtn = ImageButtonBuilder.button(upgradeBtnSprites).size(12, 12).location(this.screenArea.right() - 24, this.screenArea.bottom() + 12).onPress(btn -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedUpgradeUIPacket(this.roomCode, false), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
            this.addRenderableWidget((GuiEventListener)upgradeScreenBtn);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.width / 2.0f, 0.0f, 0.0f);
        MutableComponent rt = Component.literal((String)this.roomCode);
        pose.scale(0.7f, 0.7f, 0.7f);
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, (Component)rt, 0, 9 + 7, -2171170);
        pose.popPose();
    }

    public void onClose() {
        super.onClose();
    }

    public void updateScene(BakedLevel bakedLevel) {
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderables.remove(this.renderer);
        }
        this.renderer = (SpatialRenderer)this.addRenderableOnly((Renderable)new SpatialRenderer(bakedLevel));
        this.renderer.camera().zoom(MachineRoomScreen.calculateZoomForRoom(AABB.of((BoundingBox)bakedLevel.blockBoundaries())));
        this.renderer.camera().lookUp(0.25f);
    }

    private static float calculateZoomForRoom(AABB internalSize) {
        double maxSize = Math.max(internalSize.getXsize(), internalSize.getZsize());
        return (float)(-1.0 * maxSize) - 10.0f;
    }
}

