/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.room;

import dev.compactmods.gander.level.VirtualLevel;
import dev.compactmods.gander.render.geometry.BakedLevel;
import dev.compactmods.gander.render.geometry.LevelBakery;
import dev.compactmods.machines.client.room.MachineRoomScreen;
import dev.compactmods.machines.room.Rooms;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.joml.Vector3f;

public class ClientRoomPacketHandler {
    public static void handleBlockData(StructureTemplate blocks) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof MachineRoomScreen) {
            MachineRoomScreen mrs = (MachineRoomScreen)screen;
            VirtualLevel virtualLevel = new VirtualLevel(Minecraft.getInstance().level.registryAccess(), true);
            BoundingBox bounds = blocks.getBoundingBox(new StructurePlaceSettings(), BlockPos.ZERO);
            virtualLevel.setBounds(bounds);
            blocks.placeInWorld((ServerLevelAccessor)virtualLevel, BlockPos.ZERO, BlockPos.ZERO, new StructurePlaceSettings().setKnownShape(true), RandomSource.create(), 2);
            BakedLevel bakedLevel = LevelBakery.bakeVertices((Level)virtualLevel, (BoundingBox)bounds, (Vector3f)new Vector3f());
            mrs.updateScene(bakedLevel);
        }
    }

    public static void handleRoomSync(String roomCode, UUID owner) {
        Minecraft mc = Minecraft.getInstance();
        mc.player.setData(Rooms.DataAttachments.CURRENT_ROOM_CODE, (Object)roomCode);
    }
}

