/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.menu;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.EnchantmentMenuAccessor;
import com.mrbysco.enchantableblocks.registry.ModMenus;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.EventHooks;

public class EnchantedEnchantmentMenu
extends EnchantmentMenu {
    public EnchantedEnchantmentMenu(int containerID, Inventory inventory) {
        super(containerID, inventory);
    }

    public EnchantedEnchantmentMenu(int containerID, Inventory inventory, ContainerLevelAccess pAccess) {
        super(containerID, inventory, pAccess);
    }

    public MenuType<?> getType() {
        return ModMenus.ENCHANTED_ENCHANTMENT.get();
    }

    public void slotsChanged(Container pInventory) {
        if (pInventory == this.enchantSlots) {
            ItemStack itemstack = pInventory.getItem(0);
            if (!itemstack.isEmpty() && itemstack.isEnchantable()) {
                this.access.execute((level, pos) -> {
                    Object enchantable;
                    IdMap idmap = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    float j = 0.0f;
                    float powerMultiplier = 1.0f;
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    Holder<Enchantment> efficiencyHolder = EnchantmentUtil.getEnchantmentHolder(blockEntity.getLevel(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
                    if (blockEntity instanceof IEnchantable && (enchantable = (IEnchantable)blockEntity).hasEnchantment(efficiencyHolder)) {
                        powerMultiplier = 1.0f + (float)enchantable.getEnchantmentLevel(efficiencyHolder) * 0.5f;
                    }
                    for (BlockPos blockpos : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                        if (!EnchantingTableBlock.isValidBookShelf((Level)level, (BlockPos)pos, (BlockPos)blockpos)) continue;
                        j += level.getBlockState(pos.offset((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)level, pos.offset((Vec3i)blockpos)) * powerMultiplier;
                    }
                    this.random.setSeed((long)this.enchantmentSeed.get());
                    for (int k = 0; k < 3; ++k) {
                        this.costs[k] = EnchantmentHelper.getEnchantmentCost((RandomSource)this.random, (int)k, (int)((int)j), (ItemStack)itemstack);
                        this.enchantClue[k] = -1;
                        this.levelClue[k] = -1;
                        if (this.costs[k] < k + 1) {
                            this.costs[k] = 0;
                        }
                        this.costs[k] = EventHooks.onEnchantmentLevelSet((Level)level, (BlockPos)pos, (int)k, (int)((int)j), (ItemStack)itemstack, (int)this.costs[k]);
                    }
                    for (int l = 0; l < 3; ++l) {
                        List<EnchantmentInstance> list;
                        if (this.costs[l] <= 0 || (list = ((EnchantmentMenuAccessor)((Object)this)).invokeGetEnchantmentList(level.registryAccess(), itemstack, l, this.costs[l])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentinstance = list.get(this.random.nextInt(list.size()));
                        this.enchantClue[l] = idmap.getId((Object)enchantmentinstance.enchantment);
                        this.levelClue[l] = enchantmentinstance.level;
                    }
                    this.broadcastChanges();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                }
            }
        }
    }

    public boolean stillValid(Player player) {
        return EnchantedEnchantmentMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModRegistry.ENCHANTED_ENCHANTING_TABLE.get()));
    }
}

