/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import com.mrbysco.enchantableblocks.util.TagHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class EnchantedCampfireBlockEntity
extends CampfireBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    public EnchantedCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            SingleRecipeInput container;
            ItemStack resultStack;
            ItemStack inputStack = (ItemStack)blockEntity.items.get(i);
            if (inputStack.isEmpty()) continue;
            flag = true;
            int cookSpeed = 1;
            Holder<Enchantment> boilingHolder = EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.BOILING);
            if (blockEntity.hasEnchantment(boilingHolder)) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel(boilingHolder);
                cookSpeed += enchantmentLevel;
            }
            int n = i;
            blockEntity.cookingProgress[n] = blockEntity.cookingProgress[n] + cookSpeed;
            if (blockEntity.cookingProgress[i] < blockEntity.cookingTime[i] || !(resultStack = blockEntity.quickCheck.getRecipeFor((RecipeInput)(container = new SingleRecipeInput(inputStack)), level).map(recipe -> ((CampfireCookingRecipe)recipe.value()).assemble(container, (HolderLookup.Provider)level.registryAccess())).orElse(inputStack)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)resultStack);
            blockEntity.items.set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            EnchantedCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            if (blockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            blockEntity.cookingProgress[i] = Mth.clamp((int)(blockEntity.cookingProgress[i] - 2), (int)0, (int)blockEntity.cookingTime[i]);
        }
        if (flag) {
            EnchantedCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        RandomSource randomsource = level.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles((Level)level, (BlockPos)pos, (boolean)((Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
            }
        }
        int facing = ((Direction)state.getValue((Property)CampfireBlock.FACING)).get2DDataValue();
        for (int j = 0; j < blockEntity.items.size(); ++j) {
            if (((ItemStack)blockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + facing, 4));
            double d0 = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get();
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }
}

