/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Witch_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={Witch.class})
public abstract class WitchMixin
extends Entity {
    public WitchMixin(EntityType<? extends Entity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"performRangedAttack"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectPerformRangedAttack(LivingEntity target, float distanceFactor, CallbackInfo ci) {
        if (target instanceof Player && WitchMixin.hasWitchEnchantment((Player)target)) {
            this.throwBeneficialPotion((Witch)this, (Player)target);
            ci.cancel();
        }
    }

    private void throwBeneficialPotion(Witch witch, Player target) {
        Holder.Reference regeneration = BuiltInRegistries.POTION.getHolderOrThrow(Potions.REGENERATION.getKey());
        Holder.Reference healing = BuiltInRegistries.POTION.getHolderOrThrow(Potions.HEALING.getKey());
        Holder.Reference selectedPotion = target.getHealth() <= 4.0f ? healing : regeneration;
        ItemStack potionStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)selectedPotion);
        ThrownPotion thrownPotion = new ThrownPotion(witch.level(), (LivingEntity)witch);
        thrownPotion.setItem(potionStack);
        Vec3 vec3 = target.getDeltaMovement();
        double d0 = target.getX() + vec3.x - witch.getX();
        double d1 = target.getEyeY() - (double)1.1f - witch.getY();
        double d2 = target.getZ() + vec3.z - witch.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double speed = 0.75;
        double inaccuracy = 8.0;
        Vec3 direction = new Vec3(d0, d1 + d3 * 0.2, d2).normalize().scale(speed);
        direction = direction.add(witch.level().random.nextGaussian() * 0.0075 * inaccuracy, witch.level().random.nextGaussian() * 0.0075 * inaccuracy, witch.level().random.nextGaussian() * 0.0075 * inaccuracy);
        thrownPotion.setDeltaMovement(direction);
        if (!witch.isSilent()) {
            witch.level().playSound(null, witch.getX(), witch.getY(), witch.getZ(), SoundEvents.WITCH_THROW, SoundSource.HOSTILE, 1.0f, 0.8f + witch.level().random.nextFloat() * 0.4f);
        }
        witch.level().addFreshEntity((Entity)thrownPotion);
    }

    private static boolean hasWitchEnchantment(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TalismanUtil.isTalismanEnabled(serverPlayer, "witch_talisman")) {
                return false;
            }
            return player.hasEffect(EffectsInit.WITCH_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Witch_Talisman_Provider, (LivingEntity)serverPlayer).isPresent();
        }
        return false;
    }
}

