/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Blinded_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Blinded_Talisman
extends TalismanItem
implements Blinded_Talisman_Provider {
    private static final String talismanName = "blinded_talisman";

    public Blinded_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        double configValue = Config.BLINDED_TALISMAN_DAMAGE_FACTOR.getAsDouble() * 100.0;
        String formattedReduction = configValue == (double)((int)configValue) ? String.format("%.0f", configValue) : String.format("%.1f", configValue);
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.blinded_talisman", (Object[])new Object[]{formattedReduction}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Blinded_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onLivingDamage(LivingIncomingDamageEvent event) {
            ServerPlayer player;
            Entity source = event.getSource().getDirectEntity();
            if (source instanceof ServerPlayer && (player = (ServerPlayer)source).hasEffect(MobEffects.BLINDNESS) && (player.hasEffect(EffectsInit.BLINDED_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Blinded_Talisman_Provider, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Blinded_Talisman.talismanName)) {
                    return;
                }
                event.setAmount(event.getAmount() * (1.0f + ((Double)Config.BLINDED_TALISMAN_DAMAGE_FACTOR.get()).floatValue()));
            }
        }
    }
}

