/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Aeolus_Boots_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AeolusBootsItem
extends TalismanItem
implements ICurioItem,
Aeolus_Boots_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "aeolus_boots";
    private static final ResourceLocation SPRINT_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"aeolus_boots_sprinting_speed_boost");
    private static final AttributeModifier SPRINT_SPEED_MODIFIER = new AttributeModifier(SPRINT_SPEED_MODIFIER_ID, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public AeolusBootsItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.aeolus_boots").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!AeolusBootsItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for aeolus_boots");
            return true;
        }
    }

    private static void applyBoost(Player player) {
        AttributeInstance speed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speed != null && speed.getModifier(SPRINT_SPEED_MODIFIER_ID) == null) {
            speed.addTransientModifier(SPRINT_SPEED_MODIFIER);
        }
    }

    private static void removeBoost(Player player) {
        AttributeInstance speed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speed != null && speed.getModifier(SPRINT_SPEED_MODIFIER_ID) != null) {
            speed.removeModifier(SPRINT_SPEED_MODIFIER);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (!player.level().isClientSide) {
            AeolusBootsItem.removeBoost(player);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            boolean hasModifier;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag tag = player2.getPersistentData();
            if (tag.getBoolean("SoulOfSupersonicActive")) {
                AeolusBootsItem.removeBoost((Player)player2);
                return;
            }
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Aeolus_Boots_Provider, (LivingEntity)player2).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player2, AeolusBootsItem.charmName);
            if (!equipped || !enabled) {
                AeolusBootsItem.removeBoost((Player)player2);
                return;
            }
            AttributeInstance speed = player2.getAttribute(Attributes.MOVEMENT_SPEED);
            boolean bl = hasModifier = speed != null && speed.getModifier(SPRINT_SPEED_MODIFIER_ID) != null;
            if (player2.isSprinting()) {
                if (!hasModifier) {
                    AeolusBootsItem.applyBoost((Player)player2);
                }
            } else if (hasModifier) {
                AeolusBootsItem.removeBoost((Player)player2);
            }
        }
    }
}

