/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManagerImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.EmptyGridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.NoopStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.DirectCommitExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.SecuredGridOperations;
import com.refinedmods.refinedstorage.common.grid.SnapshotExtractTransaction;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.quartzarsenal.common.DataComponents;
import com.refinedmods.refinedstorage.quartzarsenal.common.Platform;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGridExtractTransaction;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGridOperations;
import com.refinedmods.refinedstorage.quartzarsenal.common.wirelesscraftinggrid.WirelessCraftingGridState;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;

class WirelessCraftingGrid
implements CraftingGrid {
    private final NetworkItemContext context;
    private final Level level;
    private final GridWatcherManager watchers = new GridWatcherManagerImpl();
    @Nullable
    private final RecipeMatrix<CraftingRecipe, CraftingInput> craftingRecipe;
    private final SlotReference slotReference;

    WirelessCraftingGrid(Player player, NetworkItemContext context, SlotReference slotReference) {
        this.level = player.level();
        this.context = context;
        this.slotReference = slotReference;
        this.craftingRecipe = WirelessCraftingGrid.createMatrix(player, () -> this.updateCraftingRecipe(player), slotReference);
    }

    private static RecipeMatrix<CraftingRecipe, CraftingInput> createMatrix(Player player, Runnable listener, SlotReference slotReference) {
        RecipeMatrix recipe = RecipeMatrix.crafting((Runnable)listener, () -> ((Player)player).level());
        slotReference.resolve(player).ifPresent(stack -> WirelessCraftingGrid.setMatrixSlots(stack, (RecipeMatrix<CraftingRecipe, CraftingInput>)recipe));
        return recipe;
    }

    private static void setMatrixSlots(ItemStack stack, RecipeMatrix<CraftingRecipe, CraftingInput> recipe) {
        WirelessCraftingGridState state = (WirelessCraftingGridState)stack.get(DataComponents.INSTANCE.getWirelessCraftingGridState());
        if (state == null) {
            return;
        }
        CraftingInput.Positioned positioned = state.input();
        int left = positioned.left();
        int top = positioned.top();
        CraftingInput input = positioned.input();
        for (int y = 0; y < input.height(); ++y) {
            for (int x = 0; x < input.width(); ++x) {
                int matrixIndex = x + left + (y + top) * recipe.getMatrix().getWidth();
                recipe.getMatrix().setItem(matrixIndex, input.getItem(x, y).copy());
            }
        }
    }

    private void updateCraftingRecipe(Player player) {
        if (this.craftingRecipe == null) {
            return;
        }
        CraftingInput.Positioned input = this.craftingRecipe.getMatrix().asPositionedCraftInput();
        this.slotReference.resolve(player).ifPresent(stack -> stack.set(DataComponents.INSTANCE.getWirelessCraftingGridState(), (Object)new WirelessCraftingGridState(input)));
    }

    private Optional<StorageNetworkComponent> getStorage() {
        return this.context.resolveNetwork().map(network -> (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class));
    }

    private Optional<PlatformSecurityNetworkComponent> getSecurity() {
        return this.context.resolveNetwork().map(network -> (PlatformSecurityNetworkComponent)network.getComponent(PlatformSecurityNetworkComponent.class));
    }

    private Optional<AutocraftingNetworkComponent> getAutocrafting() {
        return this.context.resolveNetwork().map(network -> (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class));
    }

    private Optional<Network> getNetworkForActiveGrid() {
        if (!this.isGridActive()) {
            return Optional.empty();
        }
        return this.context.resolveNetwork();
    }

    public RecipeMatrixContainer getCraftingMatrix() {
        return Objects.requireNonNull(this.craftingRecipe).getMatrix();
    }

    public ResultContainer getCraftingResult() {
        return Objects.requireNonNull(this.craftingRecipe).getResult();
    }

    public NonNullList<ItemStack> getRemainingItems(Player player, CraftingInput craftingInput) {
        return Objects.requireNonNull(this.craftingRecipe).getRemainingItems(this.level, player, craftingInput);
    }

    public ExtractTransaction startExtractTransaction(Player player, boolean directCommit) {
        return this.getNetworkForActiveGrid().map(network -> (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).map(storage -> new WirelessCraftingGridExtractTransaction(this.context, this.createExtractTransaction(player, directCommit, (StorageNetworkComponent)storage))).orElse(ExtractTransaction.NOOP);
    }

    private ExtractTransaction createExtractTransaction(Player player, boolean directCommit, StorageNetworkComponent storage) {
        return directCommit ? new DirectCommitExtractTransaction((RootStorage)storage) : new SnapshotExtractTransaction(player, (RootStorage)storage, this.getCraftingMatrix());
    }

    public boolean clearMatrix(Player player, boolean toPlayerInventory) {
        boolean success;
        boolean bl = success = toPlayerInventory ? this.getCraftingMatrix().clearToPlayerInventory(player) : this.clearMatrixIntoStorage(player);
        if (success) {
            this.context.drainEnergy(Platform.getConfig().getWirelessCraftingGrid().getClearMatrixEnergyUsage());
        }
        return success;
    }

    private boolean clearMatrixIntoStorage(Player player) {
        return this.getNetworkForActiveGrid().map(network -> (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).map(storage -> this.getCraftingMatrix().clearIntoStorage((RootStorage)storage, player)).orElse(false);
    }

    public void transferRecipe(Player player, List<List<ItemResource>> recipe) {
        this.context.drainEnergy(Platform.getConfig().getWirelessCraftingGrid().getRecipeTransferEnergyUsage());
        this.getCraftingMatrix().transferRecipe(player, (RootStorage)this.getNetworkForActiveGrid().map(network -> (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).orElse(null), recipe);
    }

    public void acceptQuickCraft(Player player, ItemStack craftedStack) {
        if (player.getInventory().add(craftedStack)) {
            return;
        }
        long inserted = this.getNetworkForActiveGrid().map(network -> (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).map(rootStorage -> rootStorage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)craftedStack), (long)craftedStack.getCount(), Action.EXECUTE, (Actor)new PlayerActor(player))).orElse(0L);
        if (inserted != (long)craftedStack.getCount()) {
            long remainder = (long)craftedStack.getCount() - inserted;
            ItemStack remainderStack = craftedStack.copyWithCount((int)remainder);
            player.drop(remainderStack, false);
        }
    }

    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.context.drainEnergy(Platform.getConfig().getWirelessCraftingGrid().getOpenEnergyUsage());
        this.context.resolveNetwork().ifPresent(network -> this.watchers.addWatcher(watcher, actorType, (RootStorage)network.getComponent(StorageNetworkComponent.class)));
    }

    public void removeWatcher(GridWatcher watcher) {
        this.context.resolveNetwork().ifPresent(network -> this.watchers.removeWatcher(watcher, (RootStorage)network.getComponent(StorageNetworkComponent.class)));
    }

    public Storage getItemStorage() {
        return this.getStorage().map(Storage.class::cast).orElseGet(NoopStorage::new);
    }

    public boolean isGridActive() {
        boolean networkActive = this.context.resolveNetwork().map(network -> ((EnergyNetworkComponent)network.getComponent(EnergyNetworkComponent.class)).getStored() > 0L).orElse(false);
        return networkActive && this.context.isActive();
    }

    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return this.getStorage().map(storage -> storage.getResources(actorType)).orElse(Collections.emptyList());
    }

    public Set<PlatformResourceKey> getAutocraftableResources() {
        return this.getAutocrafting().map(AutocraftingNetworkComponent::getOutputs).map(outputs -> outputs.stream().filter(PlatformResourceKey.class::isInstance).map(PlatformResourceKey.class::cast).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public GridOperations createOperations(ResourceType resourceType, ServerPlayer player) {
        return this.getStorage().flatMap(rootStorage -> this.getSecurity().map(security -> this.createGridOperations(resourceType, player, (StorageNetworkComponent)rootStorage, (PlatformSecurityNetworkComponent)security))).map(operations -> new WirelessCraftingGridOperations((GridOperations)operations, this.context, this.watchers)).orElse((GridOperations)EmptyGridOperations.INSTANCE);
    }

    private GridOperations createGridOperations(ResourceType resourceType, ServerPlayer player, StorageNetworkComponent rootStorage, PlatformSecurityNetworkComponent securityNetworkComponent) {
        PlayerActor playerActor = new PlayerActor((Player)player);
        GridOperations operations = resourceType.createGridOperations((RootStorage)rootStorage, (Actor)playerActor);
        return new SecuredGridOperations(player, securityNetworkComponent, operations);
    }

    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.getPreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.getMaxAmount(resource, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resourceKey, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.startTask(resourceKey, amount, actor, notify, cancellationToken)).map(taskId -> {
            this.context.drainEnergy(Platform.getConfig().getWirelessCraftingGrid().getAutocraftingEnergyUsage());
            return taskId;
        }).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }
}

