/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.minecraft.world.item.ItemStack;

public class InFlightRecipe {
    public static final Codec<InFlightRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)JumboFurnaceRecipe.CODEC.fieldOf("recipe").forGetter(InFlightRecipe::recipe), (App)ItemStack.CODEC.listOf().fieldOf("inputs").forGetter(InFlightRecipe::inputs), (App)Codec.INT.fieldOf("progress").forGetter(InFlightRecipe::progress)).apply((Applicative)builder, InFlightRecipe::new));
    private final JumboFurnaceRecipe recipe;
    private final List<ItemStack> inputs;
    private int progress = 0;

    public InFlightRecipe(JumboFurnaceRecipe recipe, List<ItemStack> inputs) {
        this(recipe, inputs, 0);
    }

    public InFlightRecipe(JumboFurnaceRecipe recipe, List<ItemStack> inputs, int progress) {
        this.recipe = recipe;
        this.inputs = inputs;
        this.progress = progress;
    }

    public JumboFurnaceRecipe recipe() {
        return this.recipe;
    }

    public List<ItemStack> inputs() {
        return this.inputs;
    }

    public int progress() {
        return this.progress;
    }

    public boolean incrementProgress() {
        ++this.progress;
        return this.progress >= this.recipe.cookingTime();
    }
}

