/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import net.commoble.jumbofurnace.jumbo_furnace.OutputItemHandler;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class JumboFurnaceOutputSlot
extends SlotItemHandler {
    private int removeCount = 0;
    private final Player player;

    public JumboFurnaceOutputSlot(Player player, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.player = player;
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(thePlayer, stack);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        IItemHandler iItemHandler;
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        this.removeCount = 0;
        if (!this.player.level().isClientSide() && (iItemHandler = this.getItemHandler()) instanceof OutputItemHandler) {
            OutputItemHandler outputHandler = (OutputItemHandler)iItemHandler;
            JumboFurnaceOutputSlot.spawnExpOrbs(this.player, outputHandler.getAndConsumeExperience());
        }
        EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
    }

    public static void spawnExpOrbs(Player player, float experience) {
        int orbs = Mth.floor((float)experience);
        if (orbs < Mth.ceil((float)experience) && Math.random() < (double)(experience - (float)orbs)) {
            ++orbs;
        }
        while (orbs > 0) {
            int amount = ExperienceOrb.getExperienceValue((int)orbs);
            orbs -= amount;
            player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX(), player.getY() + 0.5, player.getZ() + 0.5, amount));
        }
    }
}

