/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class JumboFurnaceItem
extends Item {
    public JumboFurnaceItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos againstPos = context.getClickedPos();
        Direction useNormal = context.getClickedFace();
        BlockPos placePos = againstPos.relative(useNormal);
        BlockPos corePos = placePos.relative(useNormal);
        Level world = context.getLevel();
        ResourceKey key = world.dimension();
        BlockPlaceContext blockContext = new BlockPlaceContext(context);
        if (MultiBlockHelper.canJumboFurnacePlaceAt((LevelAccessor)world, corePos, blockContext)) {
            Player player;
            BlockState againstState;
            List<Pair<BlockPos, BlockState>> placementStates;
            if (!world.isClientSide && !(placementStates = MultiBlockHelper.getStatesForPlacementIfPermitted((ResourceKey<Level>)key, (LevelAccessor)world, corePos, againstState = world.getBlockState(againstPos), (Entity)(player = context.getPlayer()))).isEmpty()) {
                placementStates.forEach(pair -> world.setBlockAndUpdate((BlockPos)pair.getFirst(), (BlockState)pair.getSecond()));
                BlockState jumboState = (BlockState)placementStates.get(0).getSecond();
                SoundType soundtype = jumboState.getSoundType((LevelReader)world, placePos, (Entity)player);
                world.playSound(null, placePos, jumboState.getSoundType((LevelReader)world, placePos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (player == null || !player.getAbilities().instabuild) {
                    context.getItemInHand().shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public static class Settable {
        private boolean set = false;

        public boolean get() {
            return this.set;
        }

        public void set() {
            this.set = true;
        }
    }
}

