/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.server;

import com.shynieke.geore.Reference;
import com.shynieke.geore.block.BuddingGeoreBlock;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class GeOreItemTagsProvider
extends ItemTagsProvider {
    public static final TagKey<Item> GEORE_BUDDING = GeOreItemTagsProvider.modTag("geore_budding");
    public static final TagKey<Item> GEORE_CLUSTERS = GeOreItemTagsProvider.modTag("geore_clusters");
    public static final TagKey<Item> GEORE_SMALL_BUDS = GeOreItemTagsProvider.modTag("geore_small_buds");
    public static final TagKey<Item> GEORE_MEDIUM_BUDS = GeOreItemTagsProvider.modTag("geore_medium_buds");
    public static final TagKey<Item> GEORE_LARGE_BUDS = GeOreItemTagsProvider.modTag("geore_large_buds");
    public static final TagKey<Item> GEORE_SHARDS = GeOreItemTagsProvider.modTag("geore_shards");
    public static final TagKey<Item> GEORE_BLOCKS = GeOreItemTagsProvider.modTag("geore_blocks");

    public GeOreItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "geore", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(ItemTags.COALS).add((Object)((Item)GeOreRegistry.COAL_GEORE.getShard().get()));
        for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
            this.addGeore(reg);
            this.addStorage(reg);
            this.tag(Tags.Items.GLASS_BLOCKS_TINTED).add((Object)((TintedGlassBlock)reg.getTintedGlass().get()).asItem());
        }
        this.tag(Tags.Items.BUDDING_BLOCKS).addTag(GEORE_BUDDING);
        this.tag(Tags.Items.BUDS).addTags(new TagKey[]{GEORE_SMALL_BUDS, GEORE_MEDIUM_BUDS, GEORE_LARGE_BUDS});
        this.tag(Tags.Items.CLUSTERS).addTag(GEORE_CLUSTERS);
    }

    private void addStorage(GeOreBlockReg blockReg) {
        TagKey<Item> itemTag = GeOreItemTagsProvider.modTag("storage_blocks/geore_" + blockReg.getName());
        this.tag(itemTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
    }

    private void addGeore(GeOreBlockReg blockReg) {
        this.tag(GEORE_BUDDING).add((Object)((BuddingGeoreBlock)((Object)blockReg.getBudding().get())).asItem());
        TagKey<Item> smallBudsTag = GeOreItemTagsProvider.modTag("geore_small_buds/" + blockReg.getName());
        this.tag(GEORE_SMALL_BUDS).addTag(smallBudsTag);
        this.tag(smallBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
        TagKey<Item> mediumBudsTag = GeOreItemTagsProvider.modTag("geore_medium_buds/" + blockReg.getName());
        this.tag(GEORE_MEDIUM_BUDS).addTag(mediumBudsTag);
        this.tag(mediumBudsTag).add((Object)((AmethystClusterBlock)blockReg.getSmallBud().get()).asItem());
        TagKey<Item> largeBudsTag = GeOreItemTagsProvider.modTag("geore_large_buds/" + blockReg.getName());
        this.tag(GEORE_LARGE_BUDS).addTag(largeBudsTag);
        this.tag(largeBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
        TagKey<Item> clusterTag = GeOreItemTagsProvider.modTag("geore_clusters/" + blockReg.getName());
        this.tag(GEORE_CLUSTERS).addTag(clusterTag);
        this.tag(clusterTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
        TagKey<Item> shardTag = GeOreItemTagsProvider.modTag("geore_shards/" + blockReg.getName());
        this.tag(GEORE_SHARDS).addTag(shardTag);
        this.tag(shardTag).add((Object)((Item)blockReg.getShard().get()));
        TagKey<Item> blockTag = GeOreItemTagsProvider.modTag("geore_blocks/" + blockReg.getName());
        this.tag(GEORE_BLOCKS).addTag(blockTag);
        this.tag(blockTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
    }

    private static TagKey<Item> modTag(String name) {
        return ItemTags.create((ResourceLocation)Reference.modLoc(name));
    }
}

