/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen;

import com.shynieke.geore.datagen.client.GeOreBlockModelProvider;
import com.shynieke.geore.datagen.client.GeOreBlockStateProvider;
import com.shynieke.geore.datagen.client.GeOreItemModelProvider;
import com.shynieke.geore.datagen.client.GeOreLanguageProvider;
import com.shynieke.geore.datagen.server.GeOreBlockTagsProvider;
import com.shynieke.geore.datagen.server.GeOreDatapackProvider;
import com.shynieke.geore.datagen.server.GeOreItemTagsProvider;
import com.shynieke.geore.datagen.server.GeOreLootProvider;
import com.shynieke.geore.datagen.server.GeOreRecipeProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeOreDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new GeOreLootProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new GeOreRecipeProvider(packOutput, lookupProvider));
            GeOreBlockTagsProvider blockTagsProvider = new GeOreBlockTagsProvider(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new GeOreItemTagsProvider(packOutput, lookupProvider, blockTagsProvider, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new GeOreDatapackProvider(packOutput, event.getLookupProvider(), Set.of("geore")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new GeOreLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new GeOreBlockModelProvider(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new GeOreItemModelProvider(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new GeOreBlockStateProvider(packOutput, helper));
        }
    }
}

